/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class InsertValueContext {
    private final int parametersCount;
    private final List<ExpressionSegment> valueExpressions;
    private final List<Object> parameters;

    public InsertValueContext(Collection<ExpressionSegment> assignments, List<Object> parameters, int parametersOffset) {
        this.parametersCount = this.calculateParametersCount(assignments);
        this.valueExpressions = this.getValueExpressions(assignments);
        this.parameters = this.getParameters(parameters, parametersOffset);
    }

    private int calculateParametersCount(Collection<ExpressionSegment> assignments) {
        int result = 0;
        for (ExpressionSegment each : assignments) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    private List<ExpressionSegment> getValueExpressions(Collection<ExpressionSegment> assignments) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(assignments.size());
        result.addAll(assignments);
        return result;
    }

    private List<Object> getParameters(List<Object> parameters, int parametersOffset) {
        if (0 == this.parametersCount) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.parametersCount);
        result.addAll(parameters.subList(parametersOffset, parametersOffset + this.parametersCount));
        return result;
    }

    public Object getValue(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        return valueExpression instanceof ParameterMarkerExpressionSegment ? this.parameters.get(this.getParameterIndex(valueExpression)) : ((LiteralExpressionSegment)valueExpression).getLiterals();
    }

    private int getParameterIndex(ExpressionSegment valueExpression) {
        int result = 0;
        for (ExpressionSegment each : this.valueExpressions) {
            if (valueExpression == each) {
                return result;
            }
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        throw new IllegalArgumentException("Can not get parameter index.");
    }

    public int getParametersCount() {
        return this.parametersCount;
    }

    public List<ExpressionSegment> getValueExpressions() {
        return this.valueExpressions;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "InsertValueContext(parametersCount=" + this.getParametersCount() + ", valueExpressions=" + this.getValueExpressions() + ", parameters=" + this.getParameters() + ")";
    }
}

