/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.ddl.column.ColumnDefinitionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;

public final class OracleModifyColumnDefinitionExtractor
implements CollectionSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionPhraseExtractor = new ColumnDefinitionExtractor();

    public Collection<ModifyColumnDefinitionSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Collection modifyColumnNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)ancestorNode, (RuleName)RuleName.MODIFY_COLUMN_SPECIFICATION);
        if (modifyColumnNodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ModifyColumnDefinitionSegment> result = new LinkedList<ModifyColumnDefinitionSegment>();
        for (ParserRuleContext modifyColumnNode : modifyColumnNodes) {
            for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes((ParserRuleContext)modifyColumnNode, (RuleName)RuleName.MODIFY_COL_PROPERTIES)) {
                Optional columnDefinition = this.columnDefinitionPhraseExtractor.extract(each, parameterMarkerIndexes);
                if (!columnDefinition.isPresent()) continue;
                result.add(new ModifyColumnDefinitionSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), (ColumnDefinitionSegment)columnDefinition.get()));
            }
        }
        return result;
    }
}

