/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.database.visitor;

import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorFacadeFactory;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.SQLVisitorFacade;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatementType;

public final class SQLVisitorFactory {
    public static <T> ParseTreeVisitor<T> newInstance(String databaseType, String visitorType, SQLVisitorRule visitorRule, Properties props) {
        SQLVisitorFacade facade = SQLVisitorFacadeFactory.getInstance(databaseType, visitorType);
        return SQLVisitorFactory.createParseTreeVisitor(facade, visitorRule.getType(), props);
    }

    private static <T> ParseTreeVisitor<T> createParseTreeVisitor(SQLVisitorFacade visitorFacade, SQLStatementType type, Properties props) {
        switch (type) {
            case DML: {
                return (ParseTreeVisitor)visitorFacade.getDMLVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
            case DDL: {
                return (ParseTreeVisitor)visitorFacade.getDDLVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
            case TCL: {
                return (ParseTreeVisitor)visitorFacade.getTCLVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
            case DCL: {
                return (ParseTreeVisitor)visitorFacade.getDCLVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
            case DAL: {
                return (ParseTreeVisitor)visitorFacade.getDALVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
            case RL: {
                return (ParseTreeVisitor)visitorFacade.getRLVisitorClass().getConstructor(Properties.class).newInstance(props);
            }
        }
        throw new SQLParsingException(type.name());
    }

    @Generated
    private SQLVisitorFactory() {
    }
}

