/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.filler;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import org.apache.shardingsphere.sql.parser.core.filler.SQLSegmentFiller;
import org.apache.shardingsphere.sql.parser.core.rule.registry.ParseRuleRegistry;
import org.apache.shardingsphere.sql.parser.core.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.generic.AbstractSQLStatement;

public final class SQLStatementFillerEngine {
    private final ParseRuleRegistry parseRuleRegistry;
    private final String databaseTypeName;

    public SQLStatement fill(Collection<SQLSegment> sqlSegments, int parameterMarkerCount, SQLStatementRule rule) {
        SQLStatement result = rule.getSqlStatementClass().newInstance();
        Preconditions.checkArgument((boolean)(result instanceof AbstractSQLStatement), (String)"%s must extends AbstractSQLStatement", (Object[])new Object[]{result.getClass().getName()});
        ((AbstractSQLStatement)result).setParametersCount(parameterMarkerCount);
        result.getAllSQLSegments().addAll(sqlSegments);
        for (SQLSegment each : sqlSegments) {
            Optional<SQLSegmentFiller> filler = this.parseRuleRegistry.findSQLSegmentFiller(this.databaseTypeName, each.getClass());
            if (!filler.isPresent()) continue;
            ((SQLSegmentFiller)filler.get()).fill(each, result);
        }
        return result;
    }

    @ConstructorProperties(value={"parseRuleRegistry", "databaseTypeName"})
    public SQLStatementFillerEngine(ParseRuleRegistry parseRuleRegistry, String databaseTypeName) {
        this.parseRuleRegistry = parseRuleRegistry;
        this.databaseTypeName = databaseTypeName;
    }
}

