/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.update;

import com.google.common.base.Optional;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.update.AssignmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentsSegment;

public final class SetAssignmentsExtractor
implements OptionalSQLSegmentExtractor {
    private final AssignmentExtractor assignmentExtractor = new AssignmentExtractor();

    public Optional<SetAssignmentsSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> setAssignmentsClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SET_ASSIGNMENTS_CLAUSE);
        if (!setAssignmentsClauseNode.isPresent()) {
            return Optional.absent();
        }
        LinkedList<AssignmentSegment> assignmentSegments = new LinkedList<AssignmentSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ASSIGNMENT)) {
            Optional<AssignmentSegment> assignmentSegment = this.assignmentExtractor.extract(each, parameterMarkerIndexes);
            if (!assignmentSegment.isPresent()) continue;
            assignmentSegments.add((AssignmentSegment)assignmentSegment.get());
        }
        return Optional.of((Object)new SetAssignmentsSegment(((ParserRuleContext)setAssignmentsClauseNode.get()).getStart().getStartIndex(), ((ParserRuleContext)setAssignmentsClauseNode.get()).getStop().getStopIndex(), assignmentSegments));
    }
}

