/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.update;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;

public final class AssignmentExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Optional<AssignmentSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> assignmentNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.ASSIGNMENT);
        if (!assignmentNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnSegment> columnSegment = this.columnExtractor.extract((ParserRuleContext)((ParserRuleContext)assignmentNode.get()).getChild(0), parameterMarkerIndexes);
        Preconditions.checkState((boolean)columnSegment.isPresent());
        ExpressionSegment assignmentValue = this.getAssignmentValue(parameterMarkerIndexes, (ParserRuleContext)assignmentNode.get());
        return Optional.of((Object)new AssignmentSegment(((ParserRuleContext)assignmentNode.get()).getStart().getStartIndex(), ((ParserRuleContext)assignmentNode.get()).getStop().getStopIndex(), (ColumnSegment)columnSegment.get(), assignmentValue));
    }

    private ExpressionSegment getAssignmentValue(Map<ParserRuleContext, Integer> parameterMarkerIndexes, ParserRuleContext assignmentNode) {
        Optional<? extends ExpressionSegment> result = this.expressionExtractor.extract((ParserRuleContext)assignmentNode.getChild(2), parameterMarkerIndexes);
        Preconditions.checkState((boolean)result.isPresent());
        return (ExpressionSegment)result.get();
    }
}

