/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;

public final class InsertValuesExtractor
implements CollectionSQLSegmentExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Collection<InsertValuesSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> insertValuesClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.INSERT_VALUES_CLAUSE);
        if (!insertValuesClauseNode.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes((ParserRuleContext)insertValuesClauseNode.get(), RuleName.ASSIGNMENT_VALUES)) {
            result.add(new InsertValuesSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), this.extractExpressionSegments(each, parameterMarkerIndexes)));
        }
        return result;
    }

    private List<ExpressionSegment> extractExpressionSegments(ParserRuleContext assignmentValuesNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Collection<ParserRuleContext> parserRuleContexts = ExtractorUtils.getAllDescendantNodes(assignmentValuesNode, RuleName.ASSIGNMENT_VALUE);
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(parserRuleContexts.size());
        for (ParserRuleContext each : parserRuleContexts) {
            Optional<? extends ExpressionSegment> expressionSegment = this.expressionExtractor.extract(each, parameterMarkerIndexes);
            if (!expressionSegment.isPresent()) continue;
            result.add((ExpressionSegment)expressionSegment.get());
        }
        return result;
    }
}

