/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.constant.LogicalOperator;
import org.apache.shardingsphere.sql.parser.core.constant.Paren;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.OrPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBetweenRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateRightValue;

public final class PredicateExtractor
implements OptionalSQLSegmentExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<OrPredicateSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> whereNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.WHERE_CLAUSE);
        if (!whereNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> exprNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)whereNode.get()).getChild(1), RuleName.EXPR);
        Preconditions.checkState((boolean)exprNode.isPresent());
        return this.extractRecursiveWithLogicalOperation((ParserRuleContext)exprNode.get(), parameterMarkerIndexes);
    }

    private Optional<OrPredicateSegment> extractRecursiveWithLogicalOperation(ParserRuleContext exprNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> logicalOperatorNode = ExtractorUtils.findFirstChildNodeNoneRecursive(exprNode, RuleName.LOGICAL_OPERATOR);
        if (!logicalOperatorNode.isPresent()) {
            return this.extractRecursiveWithParen(exprNode, parameterMarkerIndexes);
        }
        Optional<OrPredicateSegment> leftPredicate = this.extractPredicateSegment(exprNode, this.extractOperatorNode(exprNode, 0), 0, parameterMarkerIndexes);
        Optional<OrPredicateSegment> rightPredicate = this.extractPredicateSegment(exprNode, this.extractOperatorNode(exprNode, 2), 2, parameterMarkerIndexes);
        if (leftPredicate.isPresent() && rightPredicate.isPresent()) {
            return Optional.of((Object)this.mergePredicate((OrPredicateSegment)leftPredicate.get(), (OrPredicateSegment)rightPredicate.get(), ((ParserRuleContext)logicalOperatorNode.get()).getText()));
        }
        return leftPredicate.isPresent() ? leftPredicate : rightPredicate;
    }

    private ParserRuleContext extractOperatorNode(ParserRuleContext exprNode, int childIndex) {
        ParserRuleContext result = (ParserRuleContext)exprNode.getChild(childIndex);
        while (ExtractorUtils.findFirstChildNodeNoneRecursive(result, RuleName.LOGICAL_OPERATOR).isPresent()) {
            result = (ParserRuleContext)result.getChild(childIndex);
        }
        return result;
    }

    private Optional<OrPredicateSegment> extractPredicateSegment(ParserRuleContext exprNode, ParserRuleContext childNode, int childIndex, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        ParserRuleContext operatorNode = childNode;
        Optional result = this.extractRecursiveWithParen(childNode, parameterMarkerIndexes);
        while (!operatorNode.getParent().equals(exprNode)) {
            Optional<OrPredicateSegment> predicateSegment;
            Optional<ParserRuleContext> childLogicalNode = ExtractorUtils.findFirstChildNodeNoneRecursive(operatorNode.getParent(), RuleName.LOGICAL_OPERATOR);
            if (childLogicalNode.isPresent() && childIndex == 0) {
                predicateSegment = this.extractRecursiveWithParen((ParserRuleContext)operatorNode.getParent().getChild(2), parameterMarkerIndexes);
                if (result.isPresent() && predicateSegment.isPresent()) {
                    result = Optional.of((Object)this.mergePredicate((OrPredicateSegment)result.get(), (OrPredicateSegment)predicateSegment.get(), ((ParserRuleContext)childLogicalNode.get()).getText()));
                }
                result = result.isPresent() ? result : predicateSegment;
            } else if (childLogicalNode.isPresent() && childIndex == 2) {
                predicateSegment = this.extractRecursiveWithParen((ParserRuleContext)operatorNode.getParent().getChild(0), parameterMarkerIndexes);
                if (result.isPresent() && predicateSegment.isPresent()) {
                    result = Optional.of((Object)this.mergePredicate((OrPredicateSegment)predicateSegment.get(), (OrPredicateSegment)result.get(), ((ParserRuleContext)childLogicalNode.get()).getText()));
                }
                result = predicateSegment.isPresent() ? predicateSegment : result;
            }
            operatorNode = operatorNode.getParent();
        }
        return result;
    }

    private Optional<OrPredicateSegment> extractRecursiveWithParen(ParserRuleContext exprNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        if (1 == exprNode.getChild(0).getText().length() && Paren.isLeftParen(exprNode.getChild(0).getText().charAt(0))) {
            return this.extractRecursiveWithLogicalOperation((ParserRuleContext)exprNode.getChild(1), parameterMarkerIndexes);
        }
        Optional<PredicateSegment> predicate = this.extractPredicate(exprNode, parameterMarkerIndexes);
        return predicate.isPresent() ? Optional.of((Object)this.getOrPredicateSegment((PredicateSegment)predicate.get())) : Optional.absent();
    }

    private Optional<PredicateSegment> extractPredicate(ParserRuleContext exprNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        if (ExtractorUtils.findFirstChildNode(exprNode, RuleName.SUBQUERY).isPresent()) {
            return Optional.absent();
        }
        Optional<PredicateSegment> result = this.extractComparisonPredicate(exprNode, parameterMarkerIndexes);
        if (result.isPresent()) {
            return result;
        }
        Optional<ParserRuleContext> predicateNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.PREDICATE);
        if (!predicateNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnSegment> column = this.columnExtractor.extract((ParserRuleContext)((ParserRuleContext)predicateNode.get()).getChild(0), parameterMarkerIndexes);
        if (!column.isPresent()) {
            return Optional.absent();
        }
        if (5 == ((ParserRuleContext)predicateNode.get()).getChildCount() && "BETWEEN".equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.extractBetweenPredicate((ParserRuleContext)predicateNode.get(), parameterMarkerIndexes, (ColumnSegment)column.get())).isPresent()) {
            return result;
        }
        if (((ParserRuleContext)predicateNode.get()).getChildCount() >= 5 && "IN".equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.extractInPredicate((ParserRuleContext)predicateNode.get(), parameterMarkerIndexes, (ColumnSegment)column.get())).isPresent()) {
            return result;
        }
        return Optional.absent();
    }

    private Optional<PredicateSegment> extractComparisonPredicate(ParserRuleContext exprNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> comparisonOperatorNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.COMPARISON_OPERATOR);
        if (!comparisonOperatorNode.isPresent()) {
            return Optional.absent();
        }
        ParserRuleContext booleanPrimaryNode = ((ParserRuleContext)comparisonOperatorNode.get()).getParent();
        Optional<ParserRuleContext> leftColumnNode = ExtractorUtils.findSingleNodeFromFirstDescendant((ParserRuleContext)booleanPrimaryNode.getChild(0), RuleName.COLUMN_NAME);
        Optional<ParserRuleContext> rightColumnNode = ExtractorUtils.findSingleNodeFromFirstDescendant((ParserRuleContext)booleanPrimaryNode.getChild(2), RuleName.COLUMN_NAME);
        if (!leftColumnNode.isPresent() && !rightColumnNode.isPresent()) {
            return Optional.absent();
        }
        if (leftColumnNode.isPresent() && rightColumnNode.isPresent()) {
            Optional<ColumnSegment> leftColumn = this.columnExtractor.extract((ParserRuleContext)leftColumnNode.get(), parameterMarkerIndexes);
            Optional<ColumnSegment> rightColumn = this.columnExtractor.extract((ParserRuleContext)rightColumnNode.get(), parameterMarkerIndexes);
            Preconditions.checkState((leftColumn.isPresent() && rightColumn.isPresent() ? 1 : 0) != 0);
            return Optional.of((Object)new PredicateSegment(booleanPrimaryNode.getStart().getStartIndex(), booleanPrimaryNode.getStop().getStopIndex(), (ColumnSegment)leftColumn.get(), (PredicateRightValue)rightColumn.get()));
        }
        Optional<ColumnSegment> column = this.columnExtractor.extract(exprNode, parameterMarkerIndexes);
        Preconditions.checkState((boolean)column.isPresent());
        ParserRuleContext valueNode = leftColumnNode.isPresent() ? (ParserRuleContext)((ParserRuleContext)comparisonOperatorNode.get()).getParent().getChild(2) : (ParserRuleContext)((ParserRuleContext)comparisonOperatorNode.get()).getParent().getChild(0);
        Optional<? extends ExpressionSegment> sqlExpression = this.expressionExtractor.extract(valueNode, parameterMarkerIndexes);
        return sqlExpression.isPresent() ? Optional.of((Object)new PredicateSegment(booleanPrimaryNode.getStart().getStartIndex(), booleanPrimaryNode.getStop().getStopIndex(), (ColumnSegment)column.get(), new PredicateCompareRightValue(((ParserRuleContext)comparisonOperatorNode.get()).getText(), (ExpressionSegment)sqlExpression.get()))) : Optional.absent();
    }

    private Optional<PredicateSegment> extractBetweenPredicate(ParserRuleContext predicateNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes, ColumnSegment column) {
        Optional<? extends ExpressionSegment> betweenSQLExpression = this.expressionExtractor.extract((ParserRuleContext)predicateNode.getChild(2), parameterMarkerIndexes);
        Optional<? extends ExpressionSegment> andSQLExpression = this.expressionExtractor.extract((ParserRuleContext)predicateNode.getChild(4), parameterMarkerIndexes);
        return betweenSQLExpression.isPresent() && andSQLExpression.isPresent() ? Optional.of((Object)new PredicateSegment(predicateNode.getStart().getStartIndex(), predicateNode.getStop().getStopIndex(), column, new PredicateBetweenRightValue((ExpressionSegment)betweenSQLExpression.get(), (ExpressionSegment)andSQLExpression.get()))) : Optional.absent();
    }

    private Optional<PredicateSegment> extractInPredicate(ParserRuleContext predicateNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes, ColumnSegment column) {
        Collection<ExpressionSegment> sqlExpressions = this.extractInExpressionSegments(predicateNode, parameterMarkerIndexes);
        return sqlExpressions.isEmpty() ? Optional.absent() : Optional.of((Object)new PredicateSegment(predicateNode.getStart().getStartIndex(), predicateNode.getStop().getStopIndex(), column, new PredicateInRightValue(sqlExpressions)));
    }

    private Collection<ExpressionSegment> extractInExpressionSegments(ParserRuleContext predicateNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (int i = 3; i < predicateNode.getChildCount(); ++i) {
            if (!RuleName.EXPR.getName().equals(predicateNode.getChild(i).getClass().getSimpleName())) continue;
            Optional<? extends ExpressionSegment> expression = this.expressionExtractor.extract((ParserRuleContext)predicateNode.getChild(i), parameterMarkerIndexes);
            if (!expression.isPresent()) {
                return Collections.emptyList();
            }
            result.add((ExpressionSegment)expression.get());
        }
        return result;
    }

    private OrPredicateSegment getOrPredicateSegment(PredicateSegment predicate) {
        OrPredicateSegment result = new OrPredicateSegment();
        AndPredicate andPredicate = new AndPredicate();
        andPredicate.getPredicates().add(predicate);
        result.getAndPredicates().add(andPredicate);
        return result;
    }

    private OrPredicateSegment mergePredicate(OrPredicateSegment leftPredicate, OrPredicateSegment rightPredicate, String operator) {
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(operator);
        Preconditions.checkState((boolean)logicalOperator.isPresent());
        if (LogicalOperator.OR == logicalOperator.get()) {
            leftPredicate.getAndPredicates().addAll(rightPredicate.getAndPredicates());
            return leftPredicate;
        }
        OrPredicateSegment result = new OrPredicateSegment();
        for (AndPredicate eachLeftPredicate : leftPredicate.getAndPredicates()) {
            for (AndPredicate eachRightPredicate : rightPredicate.getAndPredicates()) {
                result.getAndPredicates().add(this.getAndPredicate(eachLeftPredicate, eachRightPredicate));
            }
        }
        return result;
    }

    private AndPredicate getAndPredicate(AndPredicate leftPredicate, AndPredicate rightPredicate) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().addAll(leftPredicate.getPredicates());
        result.getPredicates().addAll(rightPredicate.getPredicates());
        return result;
    }
}

