/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.sql.parser.cache.SQLParseResultCache;
import org.apache.shardingsphere.sql.parser.core.SQLParseKernel;
import org.apache.shardingsphere.sql.parser.core.rule.registry.ParseRuleRegistry;
import org.apache.shardingsphere.sql.parser.hook.SPIParsingHook;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SQLParseEngine {
    private final String databaseTypeName;
    private final SQLParseResultCache cache = new SQLParseResultCache();

    public SQLStatement parse(String sql, boolean useCache) {
        SPIParsingHook parsingHook = new SPIParsingHook();
        parsingHook.start(sql);
        try {
            SQLStatement result = this.parse0(sql, useCache);
            parsingHook.finishSuccess(result);
            return result;
        }
        catch (Exception ex) {
            parsingHook.finishFailure(ex);
            throw ex;
        }
    }

    private SQLStatement parse0(String sql, boolean useCache) {
        Optional<SQLStatement> cachedSQLStatement;
        if (useCache && (cachedSQLStatement = this.cache.getSQLStatement(sql)).isPresent()) {
            return (SQLStatement)cachedSQLStatement.get();
        }
        SQLStatement result = new SQLParseKernel(ParseRuleRegistry.getInstance(), this.databaseTypeName, sql).parse();
        if (useCache) {
            this.cache.put(sql, result);
        }
        return result;
    }

    @ConstructorProperties(value={"databaseTypeName"})
    public SQLParseEngine(String databaseTypeName) {
        this.databaseTypeName = databaseTypeName;
    }
}

