/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.statement.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.segment.table.TablesContext;
import org.apache.shardingsphere.sql.parser.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.predicate.PredicateExtractor;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.UpdateStatement;

public final class UpdateStatementContext
extends CommonSQLStatementContext<UpdateStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext;

    public UpdateStatementContext(UpdateStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTables());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>(((UpdateStatement)this.getSqlStatement()).getTables());
        if (((UpdateStatement)this.getSqlStatement()).getWhere().isPresent()) {
            result.addAll(this.getAllTablesFromWhere((WhereSegment)((UpdateStatement)this.getSqlStatement()).getWhere().get()));
        }
        return result;
    }

    private Collection<SimpleTableSegment> getAllTablesFromWhere(WhereSegment where) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (AndPredicate each : where.getAndPredicates()) {
            for (PredicateSegment predicate : each.getPredicates()) {
                result.addAll(new PredicateExtractor(((UpdateStatement)this.getSqlStatement()).getTables(), predicate).extractTables());
            }
        }
        return result;
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((UpdateStatement)this.getSqlStatement()).getWhere();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public String toString() {
        return "UpdateStatementContext(super=" + super.toString() + ", tablesContext=" + this.getTablesContext() + ")";
    }
}

