/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableTableScan;

public class TranslatableProjectRule
extends RelOptRule {
    public static final TranslatableProjectRule INSTANCE = new TranslatableProjectRule(RelFactories.LOGICAL_BUILDER);

    public TranslatableProjectRule(RelBuilderFactory relBuilderFactory) {
        super(TranslatableProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)TranslatableProjectRule.operand(TranslatableTableScan.class, (RelOptRuleOperandChildren)TranslatableProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "TranslatableProjectRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        TranslatableTableScan scan = (TranslatableTableScan)call.rel(1);
        int[] fields = this.getProjectFields(project.getProjects());
        List expressions = project.getProjects();
        if (0 == fields.length) {
            return;
        }
        if (fields.length == expressions.size()) {
            call.transformTo((RelNode)new TranslatableTableScan(scan.getCluster(), scan.getTable(), scan.getTranslatableTable(), scan.getFilters(), fields));
        } else {
            TranslatableTableScan tableScan = new TranslatableTableScan(scan.getCluster(), scan.getTable(), scan.getTranslatableTable(), scan.getFilters(), fields, expressions.size(), expressions);
            LogicalProject logicalProject = LogicalProject.create((RelNode)tableScan, (List)project.getHints(), (List)project.getProjects(), (RelDataType)project.getRowType());
            call.transformTo((RelNode)logicalProject);
        }
    }

    private int[] getProjectFields(List<RexNode> rexNodes) {
        ArrayList<Integer> rexInputRefs = new ArrayList<Integer>();
        for (RexNode exp : rexNodes) {
            if (!(exp instanceof RexInputRef)) continue;
            rexInputRefs.add(((RexInputRef)exp).getIndex());
        }
        int[] result = new int[rexInputRefs.size()];
        for (int index = 0; index < rexInputRefs.size(); ++index) {
            result[index] = (Integer)rexInputRefs.get(index);
        }
        return result;
    }
}

