/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.function.ResourceRequiredRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.DropReadwriteSplittingRuleStatement;

public final class DropReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeDroppedRuleNames(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeDroppedInUsed(databaseName, sqlStatement, database);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Readwrite splitting", databaseName);
        }
    }

    private void checkToBeDroppedRuleNames(String databaseName, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        if (!notExistedRuleNames.isEmpty()) {
            throw new RequiredRuleMissedException("Readwrite splitting", databaseName, sqlStatement.getRuleNames());
        }
    }

    private void checkToBeDroppedInUsed(String databaseName, DropReadwriteSplittingRuleStatement sqlStatement, ShardingSphereDatabase database) throws RuleInUsedException {
        Collection resourceBeUsed = database.getRuleMetaData().findRuleConfigurations(ResourceRequiredRuleConfiguration.class).stream().map(ResourceRequiredRuleConfiguration::getRequiredResource).flatMap(Collection::stream).collect(Collectors.toSet());
        Collection ruleInUsed = sqlStatement.getRuleNames().stream().filter(resourceBeUsed::contains).collect(Collectors.toSet());
        if (!ruleInUsed.isEmpty()) {
            throw new RuleInUsedException("Readwrite splitting", databaseName, ruleInUsed);
        }
    }

    public boolean updateCurrentRuleConfiguration(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getRuleNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return currentRuleConfig.getDataSources().isEmpty();
    }

    private void dropRule(ReadwriteSplittingRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<ReadwriteSplittingDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(each -> ruleName.equals(each.getName())).findAny();
        dataSourceRuleConfig.ifPresent(optional -> {
            currentRuleConfig.getDataSources().remove(optional);
            if (null != optional.getLoadBalancerName() && this.isLoadBalancerNotInUse(currentRuleConfig, optional.getLoadBalancerName())) {
                currentRuleConfig.getLoadBalancers().remove(optional.getLoadBalancerName());
            }
        });
    }

    private boolean isLoadBalancerNotInUse(ReadwriteSplittingRuleConfiguration currentRuleConfig, String toBeDroppedLoadBalancerName) {
        return currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getLoadBalancerName).filter(Objects::nonNull).noneMatch(toBeDroppedLoadBalancerName::equals);
    }

    public boolean hasAnyOneToBeDropped(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getRuleNames()).isEmpty();
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getType() {
        return DropReadwriteSplittingRuleStatement.class.getName();
    }
}

