/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.AlterReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.factory.ReplicaLoadBalanceAlgorithmFactory;

public final class AlterReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeAlteredRules(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeAlteredResources(databaseName, sqlStatement, database);
        this.checkToBeAlteredLoadBalancer(sqlStatement);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Readwrite splitting", databaseName);
        }
    }

    private void checkToBeAlteredRules(String databaseName, AlterReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toSet());
        Collection notExistedRuleNames = this.getToBeAlteredRuleNames(sqlStatement).stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        if (!notExistedRuleNames.isEmpty()) {
            throw new RequiredRuleMissedException("Readwrite splitting", databaseName, notExistedRuleNames);
        }
    }

    private Collection<String> getToBeAlteredRuleNames(AlterReadwriteSplittingRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toSet());
    }

    private void checkToBeAlteredLoadBalancer(AlterReadwriteSplittingRuleStatement sqlStatement) throws InvalidAlgorithmConfigurationException {
        Collection invalidLoadBalancers = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getLoadBalancer).filter(Objects::nonNull).distinct().filter(each -> !ReplicaLoadBalanceAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        if (!invalidLoadBalancers.isEmpty()) {
            throw new InvalidAlgorithmConfigurationException("Load balancers", invalidLoadBalancers);
        }
    }

    private void checkToBeAlteredResources(String databaseName, AlterReadwriteSplittingRuleStatement sqlStatement, ShardingSphereDatabase database) throws DistSQLException {
        LinkedHashSet requireResources = new LinkedHashSet();
        LinkedHashSet requireDiscoverableResources = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> {
            if (Strings.isNullOrEmpty((String)each.getAutoAwareResource())) {
                requireResources.add(each.getWriteDataSource());
                requireResources.addAll(each.getReadDataSources());
            } else {
                requireDiscoverableResources.add(each.getAutoAwareResource());
            }
        });
        Collection notExistResources = database.getResource().getNotExistedResources(requireResources);
        DistSQLException.predictionThrow((boolean)notExistResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistResources));
        Collection<String> logicResources = this.getLogicResources(database);
        Set notExistLogicResources = requireDiscoverableResources.stream().filter(each -> !logicResources.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistLogicResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, (Collection)notExistLogicResources));
    }

    private Collection<String> getLogicResources(ShardingSphereDatabase database) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Optional<ExportableRule> exportableRule = database.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("primary_data_source"))).findAny();
        exportableRule.ifPresent(optional -> {
            Map exportData = optional.export(Collections.singletonList("primary_data_source"));
            Set logicResources = exportData.getOrDefault("primary_data_source", Collections.emptyMap()).keySet();
            result.addAll(logicResources);
        });
        return result;
    }

    public RuleConfiguration buildToBeAlteredRuleConfiguration(AlterReadwriteSplittingRuleStatement sqlStatement) {
        return ReadwriteSplittingRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeAlteredRuleConfig) {
        this.dropRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        this.addRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void dropRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeAlteredRuleConfig) {
        for (ReadwriteSplittingDataSourceRuleConfiguration each : toBeAlteredRuleConfig.getDataSources()) {
            Optional<ReadwriteSplittingDataSourceRuleConfiguration> toBeRemovedDataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(dataSource -> each.getName().equals(dataSource.getName())).findAny();
            Preconditions.checkState((boolean)toBeRemovedDataSourceRuleConfig.isPresent());
            currentRuleConfig.getDataSources().remove(toBeRemovedDataSourceRuleConfig.get());
            currentRuleConfig.getLoadBalancers().remove(toBeRemovedDataSourceRuleConfig.get().getLoadBalancerName());
        }
    }

    private void addRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getDataSources().addAll(toBeAlteredRuleConfig.getDataSources());
        currentRuleConfig.getLoadBalancers().putAll(toBeAlteredRuleConfig.getLoadBalancers());
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getType() {
        return AlterReadwriteSplittingRuleStatement.class.getName();
    }
}

