/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ReadwriteSplittingRuleQueryResultSet
implements DistSQLResultSet {
    private static final String DYNAMIC = "Dynamic";
    private Iterator<Collection<Object>> data = Collections.emptyIterator();
    private Map<String, Map<String, String>> exportableAutoAwareDataSource = Collections.emptyMap();
    private Map<String, Map<String, String>> exportableDataSourceMap = Collections.emptyMap();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional ruleConfig = database.getRuleMetaData().findRuleConfigurations(ReadwriteSplittingRuleConfiguration.class).stream().findAny();
        this.buildExportableMap(database);
        ruleConfig.ifPresent(optional -> {
            this.data = this.buildData((ReadwriteSplittingRuleConfiguration)optional).iterator();
        });
    }

    private void buildExportableMap(ShardingSphereDatabase database) {
        Optional<ExportableRule> exportableRule = this.getExportableRule(database);
        exportableRule.ifPresent(optional -> {
            Map exportable = ((ExportableRule)exportableRule.get()).export(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"));
            this.exportableAutoAwareDataSource = exportable.getOrDefault("dynamic_readwrite_splitting_rules", Collections.emptyMap());
            this.exportableDataSourceMap = exportable.getOrDefault("static_readwrite_splitting_rules", Collections.emptyMap());
        });
    }

    private Optional<ExportableRule> getExportableRule(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"))).findAny();
    }

    private Collection<Collection<Object>> buildData(ReadwriteSplittingRuleConfiguration ruleConfig) {
        LinkedList<Collection<Object>> result = new LinkedList<Collection<Object>>();
        ruleConfig.getDataSources().forEach(each -> {
            Collection<Object> dataItem = this.buildDataItem((ReadwriteSplittingDataSourceRuleConfiguration)each, this.getLoadBalancers(ruleConfig));
            result.add(dataItem);
        });
        return result;
    }

    private Collection<Object> buildDataItem(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, ShardingSphereAlgorithmConfiguration> loadBalancers) {
        String name = dataSourceRuleConfig.getName();
        Map<String, String> exportDataSources = DYNAMIC.equalsIgnoreCase(dataSourceRuleConfig.getType()) ? this.exportableAutoAwareDataSource.get(name) : this.exportableDataSourceMap.get(name);
        Optional<ShardingSphereAlgorithmConfiguration> loadBalancer = Optional.ofNullable(loadBalancers.get(dataSourceRuleConfig.getLoadBalancerName()));
        return Arrays.asList(name, dataSourceRuleConfig.getAutoAwareDataSourceName().orElse(""), this.getWriteDataSourceName(dataSourceRuleConfig, exportDataSources), this.getReadDataSourceNames(dataSourceRuleConfig, exportDataSources), loadBalancer.map(ShardingSphereAlgorithmConfiguration::getType).orElse(""), loadBalancer.map(each -> PropertiesConverter.convert((Properties)each.getProps())).orElse(""));
    }

    private Map<String, ShardingSphereAlgorithmConfiguration> getLoadBalancers(ReadwriteSplittingRuleConfiguration ruleConfig) {
        Map<String, ShardingSphereAlgorithmConfiguration> loadBalancers = ruleConfig.getLoadBalancers();
        return null != loadBalancers ? loadBalancers : Collections.emptyMap();
    }

    private String getWriteDataSourceName(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        if (null != exportDataSources) {
            return exportDataSources.get("primary_data_source_name");
        }
        return dataSourceRuleConfig.getWriteDataSourceName().orElse("");
    }

    private String getReadDataSourceNames(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        if (null != exportDataSources) {
            return exportDataSources.get("replica_data_source_names");
        }
        return dataSourceRuleConfig.getReadDataSourceNames().orElse("");
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "auto_aware_data_source_name", "write_data_source_name", "read_data_source_names", "load_balancer_type", "load_balancer_props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowReadwriteSplittingRulesStatement.class.getName();
    }
}

