/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.ingest.position;

import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;

public final class IntegerPrimaryKeyPosition
extends PrimaryKeyPosition<Long>
implements IngestPosition<IntegerPrimaryKeyPosition> {
    private final long beginValue;
    private final long endValue;

    public IntegerPrimaryKeyPosition(long beginValue, long endValue) {
        this.beginValue = beginValue;
        this.endValue = endValue;
    }

    @Override
    public Long getBeginValue() {
        return this.beginValue;
    }

    @Override
    public Long getEndValue() {
        return this.endValue;
    }

    @Override
    protected Long convert(String value) {
        return Long.parseLong(value);
    }

    @Override
    protected char getType() {
        return 'i';
    }

    @Override
    public int compareTo(IntegerPrimaryKeyPosition position) {
        if (null == position) {
            return 1;
        }
        return Long.compare(this.beginValue, position.beginValue);
    }
}

