/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.job.progress;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.InventoryTaskProgress;

public final class JobProgress {
    private JobStatus status = JobStatus.RUNNING;
    private String sourceDatabaseType;
    private boolean active;
    private Map<String, InventoryTaskProgress> inventoryTaskProgressMap;
    private Map<String, IncrementalTaskProgress> incrementalTaskProgressMap;

    public Optional<IngestPosition<?>> getIncrementalPosition(String dataSourceName) {
        IncrementalTaskProgress progress = this.incrementalTaskProgressMap.get(dataSourceName);
        return Optional.ofNullable(null != progress ? progress.getPosition() : null);
    }

    public Map<String, IngestPosition<?>> getInventoryPosition(String tableName) {
        Pattern pattern = Pattern.compile(String.format("%s(#\\d+)?", tableName));
        return this.inventoryTaskProgressMap.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).find()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition()));
    }

    public String getDataSource() {
        return this.incrementalTaskProgressMap.keySet().stream().findAny().orElse("");
    }

    public int getInventoryFinishedPercentage() {
        long finished = this.inventoryTaskProgressMap.values().stream().filter(each -> each.getPosition() instanceof FinishedPosition).count();
        return this.inventoryTaskProgressMap.isEmpty() ? 0 : (int)(finished * 100L / (long)this.inventoryTaskProgressMap.size());
    }

    public long getIncrementalLatestActiveTimeMillis() {
        List delays = this.incrementalTaskProgressMap.values().stream().map(each -> each.getIncrementalTaskDelay().getLatestActiveTimeMillis()).collect(Collectors.toList());
        return delays.stream().reduce(Long::max).orElse(0L);
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public Map<String, InventoryTaskProgress> getInventoryTaskProgressMap() {
        return this.inventoryTaskProgressMap;
    }

    @Generated
    public Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap() {
        return this.incrementalTaskProgressMap;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setSourceDatabaseType(String sourceDatabaseType) {
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setInventoryTaskProgressMap(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        this.inventoryTaskProgressMap = inventoryTaskProgressMap;
    }

    @Generated
    public void setIncrementalTaskProgressMap(Map<String, IncrementalTaskProgress> incrementalTaskProgressMap) {
        this.incrementalTaskProgressMap = incrementalTaskProgressMap;
    }
}

