/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.rulealtered;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobConfiguration
implements PipelineJobConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobConfiguration.class);
    private final String jobId;
    private final String databaseName;
    private final Integer activeVersion;
    private final Integer newVersion;
    private final String sourceDatabaseType;
    private final String targetDatabaseType;
    private final PipelineDataSourceConfiguration source;
    private final PipelineDataSourceConfiguration target;
    private final Map<String, List<String>> alteredRuleYamlClassNameTablesMap;
    private final String logicTables;
    private final String tablesFirstDataNodes;
    private final List<String> jobShardingDataNodes;
    private final int concurrency;
    private final int retryTimes;

    public int getJobShardingCount() {
        return null == this.jobShardingDataNodes ? 0 : this.jobShardingDataNodes.size();
    }

    public List<String> splitLogicTableNames() {
        return Splitter.on((char)',').splitToList((CharSequence)this.logicTables);
    }

    public String toString() {
        return "RuleAlteredJobConfiguration{jobId='" + this.jobId + '\'' + ", databaseName='" + this.databaseName + '\'' + ", activeVersion=" + this.activeVersion + ", newVersion=" + this.newVersion + ", sourceDatabaseType='" + this.sourceDatabaseType + '\'' + ", targetDatabaseType='" + this.targetDatabaseType + '\'' + '}';
    }

    @Generated
    public RuleAlteredJobConfiguration(String jobId, String databaseName, Integer activeVersion, Integer newVersion, String sourceDatabaseType, String targetDatabaseType, PipelineDataSourceConfiguration source, PipelineDataSourceConfiguration target, Map<String, List<String>> alteredRuleYamlClassNameTablesMap, String logicTables, String tablesFirstDataNodes, List<String> jobShardingDataNodes, int concurrency, int retryTimes) {
        this.jobId = jobId;
        this.databaseName = databaseName;
        this.activeVersion = activeVersion;
        this.newVersion = newVersion;
        this.sourceDatabaseType = sourceDatabaseType;
        this.targetDatabaseType = targetDatabaseType;
        this.source = source;
        this.target = target;
        this.alteredRuleYamlClassNameTablesMap = alteredRuleYamlClassNameTablesMap;
        this.logicTables = logicTables;
        this.tablesFirstDataNodes = tablesFirstDataNodes;
        this.jobShardingDataNodes = jobShardingDataNodes;
        this.concurrency = concurrency;
        this.retryTimes = retryTimes;
    }

    @Override
    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public Integer getActiveVersion() {
        return this.activeVersion;
    }

    @Generated
    public Integer getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public String getTargetDatabaseType() {
        return this.targetDatabaseType;
    }

    @Generated
    public PipelineDataSourceConfiguration getSource() {
        return this.source;
    }

    @Generated
    public PipelineDataSourceConfiguration getTarget() {
        return this.target;
    }

    @Generated
    public Map<String, List<String>> getAlteredRuleYamlClassNameTablesMap() {
        return this.alteredRuleYamlClassNameTablesMap;
    }

    @Generated
    public String getLogicTables() {
        return this.logicTables;
    }

    @Generated
    public String getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public List<String> getJobShardingDataNodes() {
        return this.jobShardingDataNodes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }
}

