/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.response;

import org.apache.shardingsphere.ui.common.exception.ShardingUIException;
import org.apache.shardingsphere.ui.web.response.ResponseResult;

public final class ResponseResultUtil {
    public static ResponseResult success() {
        return ResponseResultUtil.build(null);
    }

    public static <T> ResponseResult<T> build(T model) {
        ResponseResult<T> result = new ResponseResult<T>();
        result.setSuccess(true);
        result.setModel(model);
        return result;
    }

    public static ResponseResult handleIllegalArgumentException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(400);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public static ResponseResult handleUnauthorizedException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(403);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public static ResponseResult handleShardingUIException(ShardingUIException exception) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(exception.getErrCode());
        result.setErrorMsg(exception.getMessage());
        return result;
    }

    public static ResponseResult handleUncaughtException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(500);
        result.setErrorMsg(errorMsg);
        return result;
    }

    private ResponseResultUtil() {
    }
}

