/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.advice;

import org.apache.shardingsphere.ui.common.exception.ShardingUIException;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public final class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseResult<?> handleException(Exception ex) {
        log.error("controller error", (Throwable)ex);
        if (ex instanceof IllegalArgumentException) {
            return ResponseResultUtil.handleIllegalArgumentException(ex.getMessage());
        }
        if (ex instanceof ShardingUIException) {
            return ResponseResultUtil.handleShardingUIException((ShardingUIException)ex);
        }
        return ResponseResultUtil.handleUncaughtException(ex.getMessage());
    }
}

