/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.orchestration.reg.api.RegistryCenter;
import org.apache.shardingsphere.orchestration.reg.api.RegistryCenterConfiguration;
import org.apache.shardingsphere.orchestration.reg.zookeeper.curator.CuratorZookeeperRegistryCenter;
import org.apache.shardingsphere.ui.common.constant.RegistryCenterType;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfig;

public final class RegistryCenterFactory {
    private static final ConcurrentHashMap<String, RegistryCenter> REGISTRY_CENTER_MAP = new ConcurrentHashMap();

    public static RegistryCenter createRegistryCenter(RegistryCenterConfig config) {
        RegistryCenter result = REGISTRY_CENTER_MAP.get(config.getName());
        if (null != result) {
            return result;
        }
        RegistryCenterType registryCenterType = RegistryCenterType.nameOf(config.getRegistryCenterType());
        switch (registryCenterType) {
            case ZOOKEEPER: {
                result = new CuratorZookeeperRegistryCenter();
                break;
            }
            default: {
                throw new UnsupportedOperationException(config.getName());
            }
        }
        result.init(RegistryCenterFactory.convert(config));
        REGISTRY_CENTER_MAP.put(config.getName(), result);
        return result;
    }

    private static RegistryCenterConfiguration convert(RegistryCenterConfig config) {
        RegistryCenterConfiguration result = new RegistryCenterConfiguration(config.getRegistryCenterType());
        result.setServerLists(config.getServerLists());
        result.setNamespace(config.getNamespace());
        result.setDigest(config.getDigest());
        return result;
    }

    private RegistryCenterFactory() {
    }
}

