/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.config.DataSourceConfiguration;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.core.yaml.config.common.YamlAuthenticationConfiguration;
import org.apache.shardingsphere.core.yaml.config.encrypt.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.core.yaml.swapper.impl.AuthenticationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.yaml.config.YamlDataSourceConfiguration;
import org.apache.shardingsphere.orchestration.yaml.swapper.DataSourceConfigurationYamlSwapper;

public final class ConfigurationYamlConverter {
    public static Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String data) {
        Map result = YamlEngine.unmarshal((String)data);
        Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for orchestration.");
        return Maps.transformValues((Map)result, (Function)new Function<YamlDataSourceConfiguration, DataSourceConfiguration>(){

            public DataSourceConfiguration apply(YamlDataSourceConfiguration input) {
                return new DataSourceConfigurationYamlSwapper().swap(input);
            }
        });
    }

    public static ShardingRuleConfiguration loadShardingRuleConfiguration(String data) {
        return new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)YamlEngine.unmarshal((String)data, YamlShardingRuleConfiguration.class));
    }

    public static MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration(String data) {
        return new MasterSlaveRuleConfigurationYamlSwapper().swap((YamlMasterSlaveRuleConfiguration)YamlEngine.unmarshal((String)data, YamlMasterSlaveRuleConfiguration.class));
    }

    public static Authentication loadAuthentication(String data) {
        return new AuthenticationYamlSwapper().swap((YamlAuthenticationConfiguration)YamlEngine.unmarshal((String)data, YamlAuthenticationConfiguration.class));
    }

    public static Properties loadProperties(String data) {
        return YamlEngine.unmarshalProperties((String)data);
    }

    public static EncryptRuleConfiguration loadEncryptRuleConfiguration(String data) {
        return new EncryptRuleConfigurationYamlSwapper().swap((YamlEncryptRuleConfiguration)YamlEngine.unmarshal((String)data, YamlEncryptRuleConfiguration.class));
    }

    private ConfigurationYamlConverter() {
    }
}

