/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.core.config.DataSourceConfiguration;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingSchemaService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ShardingSchemaServiceImpl
implements ShardingSchemaService {
    @Autowired
    private RegistryCenterService registryCenterService;

    @Override
    public Collection<String> getAllSchemaNames() {
        return this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.registryCenterService.getActivateConfigurationNode().getSchemaPath());
    }

    @Override
    public String getRuleConfiguration(String schemaName) {
        return this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivateConfigurationNode().getRulePath(schemaName));
    }

    @Override
    public String getDataSourceConfiguration(String schemaName) {
        return this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivateConfigurationNode().getDataSourcePath(schemaName));
    }

    @Override
    public void updateRuleConfiguration(String schemaName, String configData) {
        this.checkRuleConfiguration(configData);
        this.persistRuleConfiguration(schemaName, configData);
    }

    @Override
    public void updateDataSourceConfiguration(String schemaName, String configData) {
        this.checkDataSourceConfiguration(configData);
        this.persistDataSourceConfiguration(schemaName, configData);
    }

    @Override
    public void addSchemaConfiguration(String schemaName, String ruleConfiguration, String dataSourceConfiguration) {
        this.checkSchemaName(schemaName, this.getAllSchemaNames());
        this.checkRuleConfiguration(ruleConfiguration);
        this.checkDataSourceConfiguration(dataSourceConfiguration);
        this.persistRuleConfiguration(schemaName, ruleConfiguration);
        this.persistDataSourceConfiguration(schemaName, dataSourceConfiguration);
    }

    private void checkRuleConfiguration(String configData) {
        try {
            if (configData.contains("encryptors:\n")) {
                ConfigurationYamlConverter.loadEncryptRuleConfiguration(configData);
            } else if (configData.contains("tables:\n")) {
                ConfigurationYamlConverter.loadShardingRuleConfiguration(configData);
            } else {
                ConfigurationYamlConverter.loadMasterSlaveRuleConfiguration(configData);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("rule configuration is invalid.");
        }
    }

    private void persistRuleConfiguration(String schemaName, String ruleConfiguration) {
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivateConfigurationNode().getRulePath(schemaName), ruleConfiguration);
    }

    private void checkDataSourceConfiguration(String configData) {
        try {
            Map<String, DataSourceConfiguration> dataSourceConfigs = ConfigurationYamlConverter.loadDataSourceConfigurations(configData);
            Preconditions.checkState((!dataSourceConfigs.isEmpty() ? 1 : 0) != 0, (Object)"data source configuration is invalid.");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("data source configuration is invalid.");
        }
    }

    private void persistDataSourceConfiguration(String schemaName, String dataSourceConfiguration) {
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivateConfigurationNode().getDataSourcePath(schemaName), dataSourceConfiguration);
    }

    private void checkSchemaName(String schemaName, Collection<String> existedSchemaNames) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (Object)"schema name is invalid.");
        Preconditions.checkArgument((!existedSchemaNames.contains(schemaName) ? 1 : 0) != 0, (Object)"schema name already exists.");
    }
}

