/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Properties;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingPropertiesService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ShardingPropertiesServiceImpl
implements ShardingPropertiesService {
    @Autowired
    private RegistryCenterService registryCenterService;

    @Override
    public String loadShardingProperties() {
        return this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivateConfigurationNode().getPropsPath());
    }

    @Override
    public void updateShardingProperties(String configData) {
        this.checkShardingProperties(configData);
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivateConfigurationNode().getPropsPath(), configData);
    }

    private void checkShardingProperties(String configData) {
        try {
            Properties properties = ConfigurationYamlConverter.loadProperties(configData);
            new ShardingProperties(properties);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Sharding properties is invalid.");
        }
    }
}

