/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import com.google.common.base.Optional;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfig;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfigs;
import org.apache.shardingsphere.ui.common.exception.ShardingUIException;
import org.apache.shardingsphere.ui.repository.RegistryCenterConfigsRepository;
import org.apache.shardingsphere.ui.servcie.RegistryCenterConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class RegistryCenterConfigServiceImpl
implements RegistryCenterConfigService {
    @Autowired
    private RegistryCenterConfigsRepository registryCenterConfigsRepository;

    @Override
    public RegistryCenterConfig load(String name) {
        return this.find(name, this.loadAll());
    }

    @Override
    public Optional<RegistryCenterConfig> loadActivated() {
        return Optional.fromNullable((Object)this.findActivatedRegistryCenterConfiguration(this.loadAll()));
    }

    @Override
    public void add(RegistryCenterConfig config) {
        RegistryCenterConfigs configs = this.loadAll();
        RegistryCenterConfig existedConfig = this.find(config.getName(), configs);
        if (null != existedConfig) {
            throw new ShardingUIException(500, "Registry center already existed!");
        }
        configs.getRegistryCenterConfigs().add(config);
        this.registryCenterConfigsRepository.save(configs);
    }

    @Override
    public void delete(String name) {
        RegistryCenterConfigs configs = this.loadAll();
        RegistryCenterConfig toBeRemovedConfig = this.find(name, configs);
        if (null != toBeRemovedConfig) {
            configs.getRegistryCenterConfigs().remove(toBeRemovedConfig);
            this.registryCenterConfigsRepository.save(configs);
        }
    }

    @Override
    public void setActivated(String name) {
        RegistryCenterConfigs configs = this.loadAll();
        RegistryCenterConfig config = this.find(name, configs);
        if (null == config) {
            throw new ShardingUIException(500, "Registry center not existed!");
        }
        RegistryCenterConfig activatedConfig = this.findActivatedRegistryCenterConfiguration(configs);
        if (!config.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            config.setActivated(true);
            this.registryCenterConfigsRepository.save(configs);
        }
    }

    @Override
    public RegistryCenterConfigs loadAll() {
        return this.registryCenterConfigsRepository.load();
    }

    private RegistryCenterConfig findActivatedRegistryCenterConfiguration(RegistryCenterConfigs registryCenterConfigs) {
        for (RegistryCenterConfig each : registryCenterConfigs.getRegistryCenterConfigs()) {
            if (!each.isActivated()) continue;
            return each;
        }
        return null;
    }

    private RegistryCenterConfig find(String name, RegistryCenterConfigs configs) {
        for (RegistryCenterConfig each : configs.getRegistryCenterConfigs()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }
}

