/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.spring;

import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shardingsphere.transaction.annotation.ShardingTransactionType;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public final class ShardingTransactionTypeInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ShardingTransactionType shardingTransactionType = this.getAnnotation(methodInvocation);
        Objects.requireNonNull(shardingTransactionType, "could not found sharding transaction type annotation");
        TransactionTypeHolder.set((TransactionType)shardingTransactionType.value());
        return methodInvocation.proceed();
    }

    private ShardingTransactionType getAnnotation(MethodInvocation invocation) {
        Objects.requireNonNull(invocation.getThis());
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        ShardingTransactionType result = this.getMethodAnnotation(invocation, targetClass);
        return null != result ? result : targetClass.getAnnotation(ShardingTransactionType.class);
    }

    private ShardingTransactionType getMethodAnnotation(MethodInvocation invocation, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), targetClass);
        Method userDeclaredMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        return userDeclaredMethod.getAnnotation(ShardingTransactionType.class);
    }
}

