/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view.faces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.view.ApplicationException;
import org.apache.shale.view.ExceptionHandler;
import org.apache.shale.view.faces.ViewControllerCallbacks;

public class ViewPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 2096731130324222021L;
    private static final Log log = LogFactory.getLog((Class)ViewPhaseListener.class);
    private static final int HTTP_STATUS = 200;
    public static final String PHASE_ID = "org.apache.shale.view.PHASE_ID";

    public void afterPhase(PhaseEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("afterPhase(" + event.getFacesContext() + "," + event.getPhaseId() + ")"));
        }
        if (this.afterPhaseExceptionCheck(event)) {
            return;
        }
        PhaseId phaseId = event.getPhaseId();
        if (PhaseId.RESTORE_VIEW.equals(phaseId)) {
            this.afterRestoreView(event);
        } else if (PhaseId.RENDER_RESPONSE.equals(phaseId) || event.getFacesContext().getResponseComplete()) {
            this.afterRenderResponse(event);
        }
        event.getFacesContext().getExternalContext().getRequestMap().remove(PHASE_ID);
    }

    public void beforePhase(PhaseEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("beforePhase(" + event.getFacesContext() + "," + event.getPhaseId() + ")"));
        }
        PhaseId phaseId = event.getPhaseId();
        event.getFacesContext().getExternalContext().getRequestMap().put(PHASE_ID, phaseId);
        if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
            this.beforeRenderResponse(event);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private boolean afterPhaseExceptionCheck(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        ExternalContext econtext = context.getExternalContext();
        List list = (List)econtext.getRequestMap().get("org$apache$shale$view$EXCEPTIONS_LIST");
        if (list == null || econtext.getRequestMap().get("javax.servlet.error.exception") != null) {
            return false;
        }
        String path = econtext.getInitParameter("org.apache.shale.view.EXCEPTION_DISPATCH_PATH");
        if (path == null) {
            return false;
        }
        try {
            ApplicationException exception = new ApplicationException(list);
            Map map = econtext.getRequestMap();
            map.put("javax.servlet.error.status_code", new Integer(200));
            map.put("javax.servlet.error.exception_type", ApplicationException.class);
            map.put("javax.servlet.error.message", exception.getMessage());
            map.put("javax.servlet.error.exception", exception);
            StringBuffer sb = new StringBuffer("");
            if (econtext.getRequestServletPath() != null) {
                sb.append(econtext.getRequestServletPath());
            }
            if (econtext.getRequestPathInfo() != null) {
                sb.append(econtext.getRequestPathInfo());
            }
            map.put("javax.servlet.error.request_uri", sb.toString());
            map.put("javax.servlet.error.servlet_name", "javax.faces.webapp.FacesServlet");
            context.responseComplete();
            econtext.getRequestMap().remove("org$apache$shale$view$VIEWS_INITIALIZED");
            econtext.dispatch(path);
        }
        catch (IOException e) {
            this.handleException(context, e);
        }
        return true;
    }

    private void afterRenderResponse(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        map.remove("org$apache$shale$view$VIEWS_INITIALIZED");
        ArrayList list = new ArrayList();
        Iterator entries = map.entrySet().iterator();
        ViewControllerCallbacks callbackHandler = this.getViewControllerCallbacks(event.getFacesContext());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!callbackHandler.isViewController(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        Iterator keys = list.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                map.remove(key);
            }
            catch (Exception e) {
                this.handleException(event.getFacesContext(), e);
            }
        }
    }

    private void afterRestoreView(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        List list = (List)map.get("org$apache$shale$view$VIEWS_INITIALIZED");
        if (list == null) {
            return;
        }
        if (!event.getFacesContext().getExternalContext().getRequestMap().containsKey("org$apache$shale$view$VIEW_POSTBACK")) {
            return;
        }
        Iterator vcs = list.iterator();
        while (vcs.hasNext()) {
            Object vc = vcs.next();
            try {
                this.getViewControllerCallbacks(event.getFacesContext()).preprocess(vc);
            }
            catch (Exception e) {
                this.handleException(event.getFacesContext(), e);
            }
        }
    }

    private void beforeRenderResponse(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        String viewName = (String)map.get("org$apache$shale$view$VIEW_NAME_RENDERED");
        if (viewName == null) {
            return;
        }
        Object vc = map.get(viewName);
        if (vc == null) {
            return;
        }
        try {
            this.getViewControllerCallbacks(event.getFacesContext()).prerender(vc);
        }
        catch (Exception e) {
            this.handleException(event.getFacesContext(), e);
        }
        map.remove("org$apache$shale$view$VIEW_NAME_RENDERED");
    }

    private ViewControllerCallbacks getViewControllerCallbacks(FacesContext context) {
        ValueBinding vb = context.getApplication().createValueBinding("#{org$apache$shale$view$VIEW_CALLBACKS}");
        return (ViewControllerCallbacks)vb.getValue(context);
    }

    private void handleException(FacesContext context, Exception exception) {
        if (context == null) {
            exception.printStackTrace(System.out);
            return;
        }
        ExceptionHandler handler = (ExceptionHandler)context.getApplication().getVariableResolver().resolveVariable(context, "org$apache$shale$view$EXCEPTION_HANDLER");
        handler.handleException(exception);
    }
}

