/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.mock;

import java.util.Locale;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class MockViewHandler
extends ViewHandler {
    public Locale calculateLocale(FacesContext context) {
        Locale locale = context.getApplication().getDefaultLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public String calculateRenderKitId(FacesContext context) {
        String renderKitId = context.getApplication().getDefaultRenderKitId();
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot view = new UIViewRoot();
        view.setViewId(viewId);
        if (locale != null) {
            view.setLocale(locale);
        } else {
            view.setLocale(context.getApplication().getViewHandler().calculateLocale(context));
        }
        if (renderKitId != null) {
            view.setRenderKitId(renderKitId);
        } else {
            view.setRenderKitId(context.getApplication().getViewHandler().calculateRenderKitId(context));
        }
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + path;
    }

    public void renderView(FacesContext context, UIViewRoot view) {
        throw new UnsupportedOperationException();
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        throw new UnsupportedOperationException();
    }

    public void writeState(FacesContext context) {
        throw new UnsupportedOperationException();
    }
}

