/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.servicemix.specs.locator.OsgiLocator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.SecuritySupport;

public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";
    private static final int DEFAULT_LINE_LENGTH = 80;

    private XMLReaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader createXMLReader() throws SAXException {
        String className = null;
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader loader = NewInstance.getClassLoader();
        try {
            className = ss.getSystemProperty(property);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (className == null) {
            String service = "META-INF/services/org.xml.sax.driver";
            try {
                Class spiClass = OsgiLocator.locate(property);
                if (spiClass != null) {
                    return (XMLReader)spiClass.newInstance();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            InputStream is = null;
            ClassLoader cl = ss.getContextClassLoader();
            if (cl != null) {
                is = ss.getResourceAsStream(cl, service);
                if (is == null) {
                    cl = XMLReaderFactory.class.getClassLoader();
                    is = ss.getResourceAsStream(cl, service);
                }
            } else {
                cl = XMLReaderFactory.class.getClassLoader();
                is = ss.getResourceAsStream(cl, service);
            }
            if (is != null) {
                BufferedReader rd;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException e) {
                    rd = new BufferedReader(new InputStreamReader(is), 80);
                }
                try {
                    className = rd.readLine();
                }
                catch (Exception x) {
                }
                finally {
                    try {
                        rd.close();
                    }
                    catch (IOException exc) {}
                }
            }
        }
        if (className == null) {
            className = "org.apache.xerces.parsers.SAXParser";
        }
        if (className != null) {
            return XMLReaderFactory.loadClass(loader, className);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception e) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String className) throws SAXException {
        return XMLReaderFactory.loadClass(NewInstance.getClassLoader(), className);
    }

    private static XMLReader loadClass(ClassLoader loader, String className) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(loader, className);
        }
        catch (ClassNotFoundException e1) {
            throw new SAXException("SAX2 driver class " + className + " not found", e1);
        }
        catch (IllegalAccessException e2) {
            throw new SAXException("SAX2 driver class " + className + " found but cannot be loaded", e2);
        }
        catch (InstantiationException e3) {
            throw new SAXException("SAX2 driver class " + className + " loaded but cannot be instantiated (no empty public constructor?)", e3);
        }
        catch (ClassCastException e4) {
            throw new SAXException("SAX2 driver class " + className + " does not implement XMLReader", e4);
        }
    }
}

