/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.servicemix.specs.locator.OsgiLocator;

class ContextFinder {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.bind.v2.ContextFactory";
    private static final String JAXB_CONTEXT_PROPERTY = JAXBContext.class.getName();
    private static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";

    ContextFinder() {
    }

    public static JAXBContext find(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        String pkg;
        String url;
        String className = null;
        if (contextPath == null || contextPath.length() == 0) {
            throw new JAXBException("Invalid contextPath");
        }
        String[] packages = contextPath.split(":");
        if (packages == null || packages.length == 0) {
            throw new JAXBException("Invalid contextPath");
        }
        String[] stringArray = packages;
        int n = stringArray.length;
        for (int i = 0; i < n && (className = ContextFinder.loadClassNameFromProperties(url = (pkg = stringArray[i]).replace('.', '/') + "/jaxb.properties", classLoader)) == null; ++i) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        if (className == null) {
            String url2 = "META-INF/services/" + JAXB_CONTEXT_PROPERTY;
            className = ContextFinder.loadClassName(url2, classLoader);
        }
        if (className == null) {
            className = PLATFORM_DEFAULT_FACTORY_CLASS;
        }
        Class spi = ContextFinder.loadSpi(className, classLoader);
        try {
            Method m = spi.getMethod("createContext", String.class, ClassLoader.class, Map.class);
            return (JAXBContext)m.invoke(null, contextPath, classLoader, properties);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    public static JAXBContext find(Class[] classes, Map properties) throws JAXBException {
        String url;
        Class cl;
        Package pkg;
        String className = null;
        Class[] classArray = classes;
        int n = classArray.length;
        for (int i = 0; i < n && ((pkg = (cl = classArray[i]).getPackage()) == null || (className = ContextFinder.loadClassNameFromProperties(url = pkg.getName().replace('.', '/') + "/jaxb.properties", cl.getClassLoader())) == null); ++i) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        if (className == null) {
            String url2 = "META-INF/services/" + JAXB_CONTEXT_PROPERTY;
            className = ContextFinder.loadClassName(url2, Thread.currentThread().getContextClassLoader());
        }
        if (className == null) {
            className = PLATFORM_DEFAULT_FACTORY_CLASS;
        }
        Class spi = ContextFinder.loadSpi(className, Thread.currentThread().getContextClassLoader());
        try {
            Method m = spi.getMethod("createContext", Class[].class, Map.class);
            return (JAXBContext)m.invoke(null, classes, properties);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String loadClassNameFromProperties(String url, ClassLoader classLoader) throws JAXBException {
        String string;
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
        if (is == null) return null;
        try {
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty(JAXB_CONTEXT_FACTORY);
            if (className == null) {
                throw new JAXBException("jaxb.properties file " + url + " should contain a " + JAXB_CONTEXT_FACTORY + " property");
            }
            string = className.trim();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JAXBException(e);
            }
        }
        is.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String loadClassName(String url, ClassLoader classLoader) throws JAXBException {
        String string;
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
        if (is == null) return null;
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            string = r.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JAXBException(e);
            }
        }
        is.close();
        return string;
    }

    private static Class loadSpi(String className, ClassLoader classLoader) throws JAXBException {
        Class<JAXBContext> spiClass;
        try {
            spiClass = OsgiLocator.locate(JAXBContext.class);
            if (spiClass != null) {
                return spiClass;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            spiClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException("Provider " + className + " not found", e);
        }
        return spiClass;
    }
}

