/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicemix.nmr.api.internal;

import java.util.Map;

import org.apache.servicemix.nmr.api.Endpoint;

/**
 * This interface represents a wrapper around an Endpoint
 * which is to be used internally to access the Channel.
 *
 * @version $Revision: $
 * @since 4.0
 */
public interface InternalEndpoint extends Endpoint {

    /**
     * Retrieve the endpoint id
     *
     * @return the id of the endpoint
     */
    String getId();

    /**
     * Retrieve the metadata associated with this endpoint
     *
     * @return a non null map containing the metadata
     */
    Map<String,?> getMetaData();

    /**
     * Retrieve the channel associated with this endpoint.
     * This method is usually used by {@link Flow}s to deliver
     * exchanges to this endpoint.
     *
     * @return the channel for this endpoint
     */
    InternalChannel getChannel();

    /**
     * Retrieve the inner endpoint.
     *
     * @return the inner endpoint
     */
    Endpoint getEndpoint();

}
