/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.instance.impl.Node;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;
import org.apache.seatunnel.engine.server.telemetry.metrics.entity.JobCounter;

public class JobMetricExports
extends AbstractCollector {
    public JobMetricExports(Node node) {
        super(node);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (this.isMaster()) {
            CoordinatorService coordinatorService = this.getCoordinatorService();
            JobCounter jobCountMetrics = coordinatorService.getJobCountMetrics();
            GaugeMetricFamily metricFamily = new GaugeMetricFamily("job_count", "All job counts of seatunnel cluster ", this.clusterLabelNames("type"));
            metricFamily.addMetric(this.labelValues("canceled"), (double)jobCountMetrics.getCanceledJobCount());
            metricFamily.addMetric(this.labelValues("cancelling"), (double)jobCountMetrics.getCancellingJobCount());
            metricFamily.addMetric(this.labelValues("created"), (double)jobCountMetrics.getCreatedJobCount());
            metricFamily.addMetric(this.labelValues("pending"), (double)jobCountMetrics.getPendingJobCount());
            metricFamily.addMetric(this.labelValues("failed"), (double)jobCountMetrics.getFailedJobCount());
            metricFamily.addMetric(this.labelValues("failing"), (double)jobCountMetrics.getFailingJobCount());
            metricFamily.addMetric(this.labelValues("finished"), (double)jobCountMetrics.getFinishedJobCount());
            metricFamily.addMetric(this.labelValues("running"), (double)jobCountMetrics.getRunningJobCount());
            metricFamily.addMetric(this.labelValues("scheduled"), (double)jobCountMetrics.getScheduledJobCount());
            mfs.add((Collector.MetricFamilySamples)metricFamily);
        }
        return mfs;
    }
}

