/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.servlet;

import com.google.gson.Gson;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.rest.ConfigFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(BaseServlet.class);
    protected final NodeEngineImpl nodeEngine;

    public BaseServlet(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    protected void writeJson(HttpServletResponse resp, Object obj) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(new Gson().toJson(obj));
    }

    protected void writeJson(HttpServletResponse resp, JsonArray jsonArray) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(jsonArray.toString());
    }

    protected void writeJson(HttpServletResponse resp, JsonObject jsonObject) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(jsonObject.toString());
    }

    protected void writeJson(HttpServletResponse resp, JsonArray jsonArray, int statusCode) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.setStatus(statusCode);
        resp.getWriter().write(jsonArray.toString());
    }

    protected void writeJson(HttpServletResponse resp, JsonObject jsonObject, int statusCode) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.setStatus(statusCode);
        resp.getWriter().write(jsonObject.toString());
    }

    protected void writeJson(HttpServletResponse resp, Object obj, int statusCode) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("application/json; charset=UTF-8");
        resp.setStatus(statusCode);
        resp.getWriter().write(new Gson().toJson(obj));
    }

    protected void write(HttpServletResponse resp, Object obj) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("text/plain; charset=UTF-8");
        resp.getWriter().write(obj.toString());
    }

    protected void writeHtml(HttpServletResponse resp, Object obj) throws IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType("text/html; charset=UTF-8");
        resp.getWriter().write(obj.toString());
    }

    protected SeaTunnelServer getSeaTunnelServer(boolean shouldBeMaster) {
        Map extensionServices = this.nodeEngine.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        if (shouldBeMaster && !seaTunnelServer.isMasterNode()) {
            return null;
        }
        return seaTunnelServer;
    }

    protected byte[] requestBody(HttpServletRequest req, ConfigFormat configFormat) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = req.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                if (ConfigFormat.JSON == configFormat) continue;
                stringBuilder.append("\n");
            }
        }
        String requestBody = stringBuilder.toString();
        return requestBody.getBytes(StandardCharsets.UTF_8);
    }

    protected byte[] requestBody(HttpServletRequest req) throws IOException {
        return this.requestBody(req, ConfigFormat.JSON);
    }

    protected Map<String, String> getParameterMap(HttpServletRequest req) {
        HashMap<String, String> reqParameterMap = new HashMap<String, String>();
        Map parameterMap = req.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] paramValues;
            String paramName = (String)entry.getKey();
            for (String value : paramValues = (String[])entry.getValue()) {
                reqParameterMap.put(paramName, value);
            }
        }
        return reqParameterMap;
    }
}

