/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.seatunnel.engine.server.rest.ErrResponse;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlingFilter.class);
    private ObjectMapper objectMapper;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.objectMapper = new ObjectMapper();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (IllegalArgumentException e) {
            this.handleException(400, (HttpServletResponse)response, e);
        }
        catch (Exception e) {
            this.handleException(500, (HttpServletResponse)response, e);
        }
    }

    private void handleException(int status, HttpServletResponse response, Exception e) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json;charset=UTF-8");
        ErrResponse errorResponse = new ErrResponse();
        errorResponse.setMessage(e.getMessage());
        errorResponse.setStatus("fail");
        String jsonResponse = this.objectMapper.writeValueAsString((Object)errorResponse);
        response.getWriter().write(jsonResponse);
        log.error("Error occurred while processing request", (Throwable)e);
    }

    public void destroy() {
    }
}

