/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.allocation.strategy;

import com.hazelcast.cluster.Address;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.engine.server.resourcemanager.allocation.strategy.SlotAllocationStrategy;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotAssignedProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;

public class SlotRatioStrategy
implements SlotAllocationStrategy {
    private Map<Address, SlotAssignedProfile> workerAssignedSlots;

    @Override
    public Optional<WorkerProfile> selectWorker(List<WorkerProfile> availableWorkers) {
        Optional<WorkerProfile> workerProfile = availableWorkers.stream().min(Comparator.comparingDouble(this::calculateSlotUsage));
        workerProfile.ifPresent(profile -> this.workerAssignedSlots.merge(profile.getAddress(), new SlotAssignedProfile(0.0, 1, profile.getAssignedSlots().length), (oldVal, newVal) -> new SlotAssignedProfile(0.0, oldVal.getCurrentTaskAssignedSlotsNum() + 1, oldVal.getAssignedSlotsNum())));
        return workerProfile;
    }

    private double calculateSlotUsage(WorkerProfile worker) {
        SlotAssignedProfile slotAssignedProfile = this.workerAssignedSlots.get(worker.getAddress());
        int assignedSlots = slotAssignedProfile != null ? slotAssignedProfile.getCurrentTaskAssignedSlotsNum() : worker.getAssignedSlots().length;
        this.workerAssignedSlots.put(worker.getAddress(), new SlotAssignedProfile(0.0, assignedSlots, 0));
        int totalSlots = worker.getUnassignedSlots().length + worker.getAssignedSlots().length;
        if (totalSlots == 0) {
            return 0.5;
        }
        return (double)assignedSlots / (double)totalSlots;
    }

    public Map<Address, SlotAssignedProfile> getWorkerAssignedSlots() {
        return this.workerAssignedSlots;
    }

    public void setWorkerAssignedSlots(Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        this.workerAssignedSlots = workerAssignedSlots;
    }
}

