/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.concurrent.CompletableFuture;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.ClientToServerOperationDataSerializerHook;

public class GetJobCheckpointOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private long jobId;
    private Data response;

    public GetJobCheckpointOperation() {
    }

    public GetJobCheckpointOperation(long jobId) {
        this.jobId = jobId;
    }

    public void run() throws Exception {
        SeaTunnelServer service = (SeaTunnelServer)this.getService();
        CompletableFuture future = CompletableFuture.supplyAsync(() -> this.getNodeEngine().toData(service.getCheckpointService().getLatestCheckpointData(String.valueOf(this.jobId))), (Executor)this.getNodeEngine().getExecutionService().getExecutor("get_job_checkpoint_operation"));
        try {
            this.response = (Data)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SeaTunnelEngineException((Throwable)e);
        }
    }

    public int getFactoryId() {
        return ClientToServerOperationDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 12;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
    }

    public Object getResponse() {
        return this.response;
    }
}

