/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.spi.impl.NodeEngineImpl;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.server.HttpConfig;
import org.apache.seatunnel.engine.server.rest.filter.BasicAuthFilter;
import org.apache.seatunnel.engine.server.rest.filter.ExceptionHandlingFilter;
import org.apache.seatunnel.engine.server.rest.servlet.AllLogNameServlet;
import org.apache.seatunnel.engine.server.rest.servlet.AllNodeLogServlet;
import org.apache.seatunnel.engine.server.rest.servlet.CurrentNodeLogServlet;
import org.apache.seatunnel.engine.server.rest.servlet.EncryptConfigServlet;
import org.apache.seatunnel.engine.server.rest.servlet.FinishedJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.JobInfoServlet;
import org.apache.seatunnel.engine.server.rest.servlet.MetricsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.OverviewServlet;
import org.apache.seatunnel.engine.server.rest.servlet.RunningJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.RunningThreadsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.StopJobServlet;
import org.apache.seatunnel.engine.server.rest.servlet.StopJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobByUploadFileServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SystemMonitoringServlet;
import org.apache.seatunnel.engine.server.rest.servlet.ThreadDumpServlet;
import org.apache.seatunnel.engine.server.rest.servlet.UpdateTagsServlet;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.Connector;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.Handler;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.Server;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.DefaultServlet;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.seatunnel.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang3.StringUtils;

public class JettyService {
    private static final Logger log = LoggerFactory.getLogger(JettyService.class);
    private NodeEngineImpl nodeEngine;
    private SeaTunnelConfig seaTunnelConfig;
    Server server;

    public JettyService(NodeEngineImpl nodeEngine, SeaTunnelConfig seaTunnelConfig) {
        this.nodeEngine = nodeEngine;
        this.seaTunnelConfig = seaTunnelConfig;
        int port = seaTunnelConfig.getEngineConfig().getHttpConfig().getPort();
        if (seaTunnelConfig.getEngineConfig().getHttpConfig().isEnableDynamicPort()) {
            port = this.chooseAppropriatePort(port, seaTunnelConfig.getEngineConfig().getHttpConfig().getPortRange());
        }
        log.info("SeaTunnel REST service will start on port {}", (Object)port);
        this.server = new Server();
        if (seaTunnelConfig.getEngineConfig().getHttpConfig().isEnabled()) {
            ServerConnector httpConnector = new ServerConnector(this.server);
            httpConnector.setPort(port);
            this.server.addConnector((Connector)httpConnector);
        }
        if (seaTunnelConfig.getEngineConfig().getHttpConfig().isEnableHttps()) {
            log.info("SeaTunnel REST service will start on https port {}", (Object)port);
            this.enableHttps(this.server, seaTunnelConfig);
        }
    }

    public void enableHttps(Server server, SeaTunnelConfig seaTunnelConfig) {
        HttpConfig httpConfig = seaTunnelConfig.getEngineConfig().getHttpConfig();
        int httpsPort = httpConfig.getHttpsPort();
        String keyStorePath = httpConfig.getKeyStorePath();
        String keyStorePassword = httpConfig.getKeyStorePassword();
        String keyManagerPassword = httpConfig.getKeyManagerPassword();
        String trustStorePath = httpConfig.getTrustStorePath();
        String trustStorePassword = httpConfig.getTrustStorePassword();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(keyManagerPassword);
        if (StringUtils.isNotBlank((CharSequence)trustStorePath) && StringUtils.isNotBlank((CharSequence)trustStorePassword)) {
            sslContextFactory.setTrustStorePath(trustStorePath);
            sslContextFactory.setTrustStorePassword(trustStorePassword);
            sslContextFactory.setNeedClientAuth(true);
            log.info("SeaTunnel REST service will start with mutual auth");
        }
        ServerConnector sslConnector = new ServerConnector(server, (SslContextFactory)sslContextFactory);
        sslConnector.setPort(httpsPort);
        server.addConnector((Connector)sslConnector);
        log.info("SeaTunnel REST service will start on https port {}", (Object)httpsPort);
    }

    public void createJettyServer() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(this.seaTunnelConfig.getEngineConfig().getHttpConfig().getContextPath());
        FilterHolder exceptionFilterHolder = new FilterHolder((Filter)new ExceptionHandlingFilter());
        context.addFilter(exceptionFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        HttpConfig httpConfig = this.seaTunnelConfig.getEngineConfig().getHttpConfig();
        if (httpConfig.isEnableBasicAuth()) {
            log.info("Basic authentication is enabled for web UI");
            FilterHolder basicAuthFilterHolder = new FilterHolder((Filter)new BasicAuthFilter(httpConfig));
            context.addFilter(basicAuthFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        ServletHolder defaultServlet = new ServletHolder("default", DefaultServlet.class);
        URL uiResource = JettyService.class.getClassLoader().getResource("ui");
        if (uiResource != null) {
            defaultServlet.setInitParameter("resourceBase", uiResource.toExternalForm());
        } else {
            log.warn("UI resources not found in classpath");
        }
        context.addServlet(defaultServlet, "/");
        ServletHolder overviewHolder = new ServletHolder((Servlet)new OverviewServlet(this.nodeEngine));
        ServletHolder runningJobsHolder = new ServletHolder((Servlet)new RunningJobsServlet(this.nodeEngine));
        ServletHolder finishedJobsHolder = new ServletHolder((Servlet)new FinishedJobsServlet(this.nodeEngine));
        ServletHolder systemMonitoringHolder = new ServletHolder((Servlet)new SystemMonitoringServlet(this.nodeEngine));
        ServletHolder jobInfoHolder = new ServletHolder((Servlet)new JobInfoServlet(this.nodeEngine));
        ServletHolder threadDumpHolder = new ServletHolder((Servlet)new ThreadDumpServlet(this.nodeEngine));
        ServletHolder submitJobHolder = new ServletHolder((Servlet)new SubmitJobServlet(this.nodeEngine));
        ServletHolder submitJobByUploadFileHolder = new ServletHolder((Servlet)new SubmitJobByUploadFileServlet(this.nodeEngine));
        ServletHolder submitJobsHolder = new ServletHolder((Servlet)new SubmitJobsServlet(this.nodeEngine));
        ServletHolder stopJobHolder = new ServletHolder((Servlet)new StopJobServlet(this.nodeEngine));
        ServletHolder stopJobsHolder = new ServletHolder((Servlet)new StopJobsServlet(this.nodeEngine));
        ServletHolder encryptConfigHolder = new ServletHolder((Servlet)new EncryptConfigServlet(this.nodeEngine));
        ServletHolder updateTagsHandler = new ServletHolder((Servlet)new UpdateTagsServlet(this.nodeEngine));
        ServletHolder runningThreadsHolder = new ServletHolder((Servlet)new RunningThreadsServlet(this.nodeEngine));
        ServletHolder allNodeLogServletHolder = new ServletHolder((Servlet)new AllNodeLogServlet(this.nodeEngine));
        ServletHolder currentNodeLogServlet = new ServletHolder((Servlet)new CurrentNodeLogServlet(this.nodeEngine));
        ServletHolder allLogNameServlet = new ServletHolder((Servlet)new AllLogNameServlet(this.nodeEngine));
        ServletHolder metricsServlet = new ServletHolder((Servlet)new MetricsServlet(this.nodeEngine));
        context.addServlet(overviewHolder, JettyService.convertUrlToPath("/overview"));
        context.addServlet(runningJobsHolder, JettyService.convertUrlToPath("/running-jobs"));
        context.addServlet(finishedJobsHolder, JettyService.convertUrlToPath("/finished-jobs"));
        context.addServlet(systemMonitoringHolder, JettyService.convertUrlToPath("/system-monitoring-information"));
        context.addServlet(jobInfoHolder, JettyService.convertUrlToPath("/job-info"));
        context.addServlet(jobInfoHolder, JettyService.convertUrlToPath("/running-job"));
        context.addServlet(threadDumpHolder, JettyService.convertUrlToPath("/thread-dump"));
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement("");
        submitJobByUploadFileHolder.getRegistration().setMultipartConfig(multipartConfigElement);
        context.addServlet(submitJobByUploadFileHolder, JettyService.convertUrlToPath("/submit-job/upload"));
        context.addServlet(submitJobHolder, JettyService.convertUrlToPath("/submit-job"));
        context.addServlet(submitJobsHolder, JettyService.convertUrlToPath("/submit-jobs"));
        context.addServlet(stopJobHolder, JettyService.convertUrlToPath("/stop-job"));
        context.addServlet(stopJobsHolder, JettyService.convertUrlToPath("/stop-jobs"));
        context.addServlet(encryptConfigHolder, JettyService.convertUrlToPath("/encrypt-config"));
        context.addServlet(updateTagsHandler, JettyService.convertUrlToPath("/update-tags"));
        context.addServlet(runningThreadsHolder, JettyService.convertUrlToPath("/running-threads"));
        context.addServlet(allNodeLogServletHolder, JettyService.convertUrlToPath("/logs"));
        context.addServlet(currentNodeLogServlet, JettyService.convertUrlToPath("/log"));
        context.addServlet(allLogNameServlet, JettyService.convertUrlToPath("/get-all-log-name"));
        context.addServlet(metricsServlet, JettyService.convertUrlToPath("/metrics"));
        context.addServlet(metricsServlet, JettyService.convertUrlToPath("/openmetrics"));
        this.server.setHandler((Handler)context);
        try {
            this.server.start();
        }
        catch (Exception e) {
            log.error("Jetty server start failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void shutdownJettyServer() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.error("Jetty server stop failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String convertUrlToPath(String url) {
        return url + "/*";
    }

    public int chooseAppropriatePort(int initialPort, int portRange) {
        for (int port = initialPort; port <= initialPort + portRange; ++port) {
            if (this.isPortInUse(port)) continue;
            return port;
        }
        throw new RuntimeException("Jetty failed to start, No available port found in the range!");
    }

    /*
     * Exception decompiling
     */
    private boolean isPortInUse(int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

