/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorageFactory;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.utils.FactoryUtil;
import org.apache.seatunnel.engine.core.job.JobPipelineCheckpointData;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.apache.seatunnel.engine.serializer.protobuf.ProtoStuffSerializer;
import org.apache.seatunnel.engine.server.checkpoint.ActionState;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;

public class CheckpointService {
    private CheckpointStorage checkpointStorage;
    private Serializer serializer = new ProtoStuffSerializer();

    public CheckpointService(CheckpointConfig config) {
        this.checkpointStorage = ((CheckpointStorageFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CheckpointStorageFactory.class, (String)config.getStorage().getStorage())).create(config.getStorage().getStoragePluginConfig());
    }

    public List<CompletedCheckpoint> getLatestCheckpoint(String jobId) {
        List pipelineStates = this.checkpointStorage.getLatestCheckpoint(jobId);
        return pipelineStates.stream().map(pipelineState -> {
            try {
                return (CompletedCheckpoint)this.serializer.deserialize(pipelineState.getStates(), CompletedCheckpoint.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).sorted(Comparator.comparingInt(CompletedCheckpoint::getPipelineId)).collect(Collectors.toList());
    }

    public List<JobPipelineCheckpointData> getLatestCheckpointData(String jobId) {
        return this.getLatestCheckpoint(jobId).stream().map(checkpoint -> {
            HashMap<String, JobPipelineCheckpointData.ActionState> taskStates = new HashMap<String, JobPipelineCheckpointData.ActionState>();
            for (ActionStateKey stateKey : checkpoint.getTaskStates().keySet()) {
                ActionState taskState = checkpoint.getTaskStates().get(stateKey);
                List subtaskStates = taskState.getSubtaskStates().stream().map(state -> {
                    if (state == null) {
                        return null;
                    }
                    return new JobPipelineCheckpointData.ActionSubtaskState(state.getIndex(), state.getState());
                }).collect(Collectors.toList());
                ActionSubtaskState coordinatorState = taskState.getCoordinatorState();
                JobPipelineCheckpointData.ActionState actionState = new JobPipelineCheckpointData.ActionState(coordinatorState == null ? null : coordinatorState.getState(), subtaskStates);
                taskStates.put(stateKey.getName(), actionState);
            }
            return JobPipelineCheckpointData.builder().jobId(checkpoint.getJobId()).pipelineId(checkpoint.getPipelineId()).checkpointId(checkpoint.getCheckpointId()).checkpointType(checkpoint.getCheckpointType()).triggerTimestamp(checkpoint.getCheckpointTimestamp()).completedTimestamp(checkpoint.getCompletedTimestamp()).taskStates(taskStates).build();
        }).collect(Collectors.toList());
    }

    public CheckpointStorage getCheckpointStorage() {
        return this.checkpointStorage;
    }
}

