/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.service;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.common.config.server.HttpConfig;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.rest.service.BaseLogService;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class LogService
extends BaseLogService {
    private static final Logger log = LoggerFactory.getLogger(LogService.class);

    public LogService(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
    }

    public List<String> allLogName() {
        String logPath = this.getLogPath();
        List logFileList = FileUtils.listFile((String)logPath);
        if (logFileList == null) {
            return null;
        }
        return logFileList.stream().map(File::getName).collect(Collectors.toList());
    }

    public List<Tuple3<String, String, String>> allLogNameList(String jobId) {
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
        HttpConfig httpConfig = seaTunnelServer.getSeaTunnelConfig().getEngineConfig().getHttpConfig();
        String contextPath = httpConfig.getContextPath();
        int port = httpConfig.getPort();
        ArrayList<Tuple3<String, String, String>> allLogNameList = new ArrayList<Tuple3<String, String, String>>();
        JsonArray systemMonitoringInformationJsonValues = this.getSystemMonitoringInformationJsonValues();
        systemMonitoringInformationJsonValues.forEach(systemMonitoringInformation -> {
            String host = systemMonitoringInformation.asObject().get("host").asString();
            String url = "http://" + host + ":" + port + contextPath;
            String allName = this.sendGet(url + "/get-all-log-name");
            log.debug(String.format("Request: %s , Result: %s", url, allName));
            ArrayNode jsonNodes = JsonUtils.parseArray((String)allName);
            jsonNodes.forEach(jsonNode -> {
                String fileName = jsonNode.asText();
                if (StringUtils.isNotBlank((CharSequence)jobId) && !fileName.contains(jobId)) {
                    return;
                }
                allLogNameList.add(new Tuple3((Object)(host + ":" + port), (Object)(url + "/logs" + "/" + fileName), (Object)fileName));
            });
        });
        return allLogNameList;
    }

    public JsonArray allNodeLogFormatJson(String jobId) {
        return this.allLogNameList(jobId).stream().map(tuple -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("node", (String)tuple._1());
            jsonObject.add("logLink", (String)tuple._2());
            jsonObject.add("logName", (String)tuple._3());
            return jsonObject;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
    }

    public String allNodeLogFormatHtml(String jobId) {
        StringBuffer logLink = new StringBuffer();
        this.allLogNameList(jobId).forEach(tuple -> logLink.append(this.buildLogLink((String)tuple._2(), (String)tuple._3())));
        return this.buildWebSiteContent(logLink);
    }

    public String currentNodeLog(String uri) {
        List logFileList = FileUtils.listFile((String)this.getLogPath());
        StringBuffer logLink = new StringBuffer();
        if (logFileList != null) {
            for (File file : logFileList) {
                logLink.append(this.buildLogLink("log/" + file.getName(), file.getName()));
            }
        }
        return this.buildWebSiteContent(logLink);
    }
}

