/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.allocation.strategy;

import com.hazelcast.cluster.Address;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.engine.server.resourcemanager.allocation.strategy.SlotAllocationStrategy;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotAssignedProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SystemLoadInfo;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.utils.SystemLoadCalculate;
import org.apache.seatunnel.shade.com.google.common.collect.EvictingQueue;

public class SystemLoadStrategy
implements SlotAllocationStrategy {
    private final Map<Address, EvictingQueue<SystemLoadInfo>> workerLoadMap;
    private Map<Address, SlotAssignedProfile> workerAssignedSlots;

    public SystemLoadStrategy(Map<Address, EvictingQueue<SystemLoadInfo>> workerLoadMap) {
        this.workerLoadMap = workerLoadMap;
    }

    public SystemLoadStrategy() {
        this.workerLoadMap = new ConcurrentHashMap<Address, EvictingQueue<SystemLoadInfo>>();
    }

    public void updateWorkerLoad(Address address, SystemLoadInfo systemLoadInfo) {
        this.workerLoadMap.computeIfAbsent(address, k -> EvictingQueue.create((int)5)).add((Object)systemLoadInfo);
    }

    @Override
    public Optional<WorkerProfile> selectWorker(List<WorkerProfile> availableWorkers) {
        Optional<WorkerProfile> workerProfile = availableWorkers.stream().max(Comparator.comparingDouble(w -> this.calculateWeight((WorkerProfile)w, this.workerAssignedSlots)));
        workerProfile.ifPresent(profile -> this.workerAssignedSlots.merge(profile.getAddress(), new SlotAssignedProfile(0.0, 1, profile.getAssignedSlots().length), (oldVal, newVal) -> new SlotAssignedProfile(oldVal.getSingleSlotUseResource(), oldVal.getCurrentTaskAssignedSlotsNum() + 1, oldVal.getAssignedSlotsNum())));
        return workerProfile;
    }

    public Double calculateWeight(WorkerProfile workerProfile, Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        SystemLoadCalculate systemLoadCalculate = new SystemLoadCalculate();
        return systemLoadCalculate.calculate(this.workerLoadMap.get(workerProfile.getAddress()), workerProfile, workerAssignedSlots);
    }

    public Map<Address, SlotAssignedProfile> getWorkerAssignedSlots() {
        return this.workerAssignedSlots;
    }

    public void setWorkerAssignedSlots(Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        this.workerAssignedSlots = workerAssignedSlots;
    }
}

