/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.map.IMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.apache.seatunnel.api.options.EnvCommonOptions;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.common.utils.concurrent.CompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.PipelineExecutionState;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorStatus;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.ResourceUtils;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubPlan {
    private static final Logger log = LoggerFactory.getLogger(SubPlan.class);
    private final int pipelineMaxRestoreNum;
    private final int pipelineRestoreIntervalSeconds;
    private final List<PhysicalVertex> physicalVertexList;
    private final List<PhysicalVertex> coordinatorVertexList;
    private final int pipelineId;
    private final AtomicInteger finishedTaskNum = new AtomicInteger(0);
    private final AtomicInteger canceledTaskNum = new AtomicInteger(0);
    private final AtomicInteger failedTaskNum = new AtomicInteger(0);
    private final String pipelineFullName;
    private final IMap<Object, Object> runningJobStateIMap;
    private final Map<String, String> tags;
    private final IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private CompletableFuture<PipelineExecutionState> pipelineFuture;
    private final PipelineLocation pipelineLocation;
    private AtomicReference<String> errorByPhysicalVertex = new AtomicReference();
    private final ExecutorService executorService;
    private JobMaster jobMaster;
    private PassiveCompletableFuture<Void> reSchedulerPipelineFuture;
    private Integer pipelineRestoreNum;
    private final Object restoreLock = new Object();
    private volatile PipelineStatus currPipelineStatus;
    public volatile boolean isRunning = false;
    private Map<TaskGroupLocation, SlotProfile> slotProfiles;

    public SubPlan(int pipelineId, int totalPipelineNum, long initializationTimestamp, @NonNull List<PhysicalVertex> physicalVertexList, @NonNull List<PhysicalVertex> coordinatorVertexList, @NonNull JobImmutableInformation jobImmutableInformation, @NonNull ExecutorService executorService, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap, Map<String, String> tags) {
        if (physicalVertexList == null) {
            throw new NullPointerException("physicalVertexList is marked non-null but is null");
        }
        if (coordinatorVertexList == null) {
            throw new NullPointerException("coordinatorVertexList is marked non-null but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked non-null but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked non-null but is null");
        }
        this.pipelineId = pipelineId;
        this.pipelineLocation = new PipelineLocation(jobImmutableInformation.getJobId(), pipelineId);
        this.pipelineFuture = new CompletableFuture();
        this.physicalVertexList = physicalVertexList;
        this.coordinatorVertexList = coordinatorVertexList;
        this.pipelineRestoreNum = 0;
        this.pipelineMaxRestoreNum = Integer.parseInt(jobImmutableInformation.getJobConfig().getEnvOptions().computeIfAbsent(EnvCommonOptions.JOB_RETRY_TIMES.key(), key -> (Integer)EnvCommonOptions.JOB_RETRY_TIMES.defaultValue()).toString());
        this.pipelineRestoreIntervalSeconds = Integer.parseInt(jobImmutableInformation.getJobConfig().getEnvOptions().computeIfAbsent(EnvCommonOptions.JOB_RETRY_INTERVAL_SECONDS.key(), key -> (Integer)EnvCommonOptions.JOB_RETRY_INTERVAL_SECONDS.defaultValue()).toString());
        Long[] stateTimestamps = new Long[PipelineStatus.values().length];
        if (runningJobStateTimestampsIMap.get((Object)this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.INITIALIZING.ordinal()] = initializationTimestamp;
            runningJobStateTimestampsIMap.put((Object)this.pipelineLocation, (Object)stateTimestamps);
        }
        if (runningJobStateIMap.get((Object)this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.CREATED.ordinal()] = System.currentTimeMillis();
            runningJobStateTimestampsIMap.put((Object)this.pipelineLocation, (Object)stateTimestamps);
            runningJobStateIMap.put((Object)this.pipelineLocation, (Object)PipelineStatus.CREATED);
        }
        this.currPipelineStatus = (PipelineStatus)runningJobStateIMap.get((Object)this.pipelineLocation);
        this.pipelineFullName = String.format("Job %s (%s), Pipeline: [(%d/%d)]", jobImmutableInformation.getJobConfig().getName(), jobImmutableInformation.getJobId(), pipelineId, totalPipelineNum);
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.executorService = executorService;
        this.tags = tags;
    }

    public synchronized PassiveCompletableFuture<PipelineExecutionState> initStateFuture() {
        this.errorByPhysicalVertex = new AtomicReference();
        this.physicalVertexList.forEach(physicalVertex -> this.addPhysicalVertexCallBack(physicalVertex.initStateFuture(), (PhysicalVertex)physicalVertex));
        this.coordinatorVertexList.forEach(coordinator -> this.addPhysicalVertexCallBack(coordinator.initStateFuture(), (PhysicalVertex)coordinator));
        this.pipelineFuture = new CompletableFuture();
        return new PassiveCompletableFuture(this.pipelineFuture);
    }

    private void addPhysicalVertexCallBack(PassiveCompletableFuture<TaskExecutionState> future, PhysicalVertex task) {
        future.thenAcceptAsync(executionState -> {
            try {
                log.info("{} future complete with state {}", (Object)task.getTaskFullName(), (Object)executionState.getExecutionState());
                if (ExecutionState.CANCELED.equals(executionState.getExecutionState())) {
                    this.canceledTaskNum.incrementAndGet();
                } else if (ExecutionState.FAILED.equals(executionState.getExecutionState())) {
                    log.error(String.format("Task %s Failed in %s, Begin to cancel other tasks in this pipeline.", executionState.getTaskGroupLocation(), this.getPipelineFullName()));
                    this.failedTaskNum.incrementAndGet();
                    this.errorByPhysicalVertex.compareAndSet(null, executionState.getThrowableMsg());
                    this.updatePipelineState(PipelineStatus.FAILING);
                }
                if (this.finishedTaskNum.incrementAndGet() == this.physicalVertexList.size() + this.coordinatorVertexList.size()) {
                    PipelineStatus pipelineEndState = this.getPipelineEndState();
                    log.info(String.format("%s will end with state %s", this.pipelineFullName, pipelineEndState));
                    this.updatePipelineState(pipelineEndState);
                }
            }
            catch (Throwable e) {
                log.error(String.format("Never come here. handle %s %s error", executionState.getTaskGroupLocation(), executionState.getExecutionState()), e);
            }
        }, (Executor)this.executorService);
    }

    private PipelineStatus getPipelineEndState() {
        PipelineStatus pipelineStatus = null;
        if (this.failedTaskNum.get() > 0) {
            pipelineStatus = PipelineStatus.FAILED;
            this.jobMaster.getCheckpointManager().cancelCheckpoint(this.getPipelineId()).join();
        } else if (this.canceledTaskNum.get() > 0) {
            pipelineStatus = PipelineStatus.CANCELED;
            CheckpointCoordinatorState checkpointCoordinatorState = (CheckpointCoordinatorState)this.jobMaster.getCheckpointManager().cancelCheckpoint(this.getPipelineId()).join();
            if (CheckpointCoordinatorStatus.FAILED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.FAILED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            }
            if (this.getPipelineState().equals((Object)PipelineStatus.FAILING)) {
                pipelineStatus = PipelineStatus.FAILED;
            }
        } else {
            pipelineStatus = PipelineStatus.FINISHED;
            CheckpointCoordinatorState checkpointCoordinatorState = (CheckpointCoordinatorState)this.jobMaster.getCheckpointManager().waitCheckpointCoordinatorComplete(this.getPipelineId()).join();
            if (CheckpointCoordinatorStatus.FAILED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.FAILED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            } else if (CheckpointCoordinatorStatus.CANCELED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.CANCELED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            }
        }
        return pipelineStatus;
    }

    private boolean checkNeedRestore(PipelineStatus pipelineStatus) {
        return this.canRestorePipeline() && !PipelineStatus.FINISHED.equals((Object)pipelineStatus);
    }

    private void notifyCheckpointManagerPipelineEnd(PipelineStatus pipelineStatus) {
        if (this.jobMaster.getCheckpointManager() == null) {
            return;
        }
        this.jobMaster.getCheckpointManager().listenPipeline(this.getPipelineLocation().getPipelineId(), pipelineStatus).join();
    }

    private void subPlanDone(PipelineStatus pipelineStatus) {
        try {
            RetryUtils.retryWithException(() -> {
                this.jobMaster.savePipelineMetricsToHistory(this.getPipelineLocation());
                try {
                    this.jobMaster.removeMetricsContext(this.getPipelineLocation(), pipelineStatus);
                }
                catch (Throwable e) {
                    log.error("Remove metrics context for pipeline {} failed, with exception: {}", (Object)this.pipelineFullName, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
                this.notifyCheckpointManagerPipelineEnd(pipelineStatus);
                this.jobMaster.releasePipelineResource(this);
                return null;
            }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException((Throwable)exception), 2000L));
        }
        catch (Exception e) {
            log.warn("The cleaning operation before pipeline {} completion is not completed, with exception: {} ", (Object)this.pipelineFullName, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public boolean canRestorePipeline() {
        return this.jobMaster.isNeedRestore() && this.getPipelineRestoreNum() < this.pipelineMaxRestoreNum;
    }

    public synchronized void updatePipelineState(@NonNull PipelineStatus targetState) {
        block5: {
            if (targetState == null) {
                throw new NullPointerException("targetState is marked non-null but is null");
            }
            try {
                PipelineStatus current = (PipelineStatus)this.runningJobStateIMap.get((Object)this.pipelineLocation);
                log.debug(String.format("Try to update the %s state from %s to %s", this.pipelineFullName, current, targetState));
                if (current.equals((Object)targetState)) {
                    log.info("{} current state equals target state: {}, skip", (Object)this.pipelineFullName, (Object)targetState);
                    return;
                }
                if (current.isEndState()) {
                    String message = "Pipeline is trying to leave terminal state " + current;
                    log.info(message);
                    return;
                }
                PipelineStatus finalTargetState = targetState;
                RetryUtils.retryWithException(() -> {
                    this.updateStateTimestamps(finalTargetState);
                    this.runningJobStateIMap.set((Object)this.pipelineLocation, (Object)finalTargetState);
                    return null;
                }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException((Throwable)exception), 2000L));
                this.currPipelineStatus = targetState;
                log.info(String.format("%s turned from state %s to %s.", this.pipelineFullName, current, targetState));
                this.stateProcess();
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getMessage((Throwable)e));
                if (targetState.equals((Object)PipelineStatus.FAILING)) break block5;
                this.makePipelineFailing(e);
            }
        }
    }

    public synchronized void cancelPipeline() {
        this.cancelCheckpointCoordinator();
        if (!this.getPipelineState().isEndState()) {
            this.updatePipelineState(PipelineStatus.CANCELING);
        }
    }

    private void cancelCheckpointCoordinator() {
        if (this.jobMaster.getCheckpointManager() != null) {
            this.jobMaster.getCheckpointManager().cancelCheckpoint(this.pipelineId).join();
        }
    }

    private synchronized void reset() throws Exception {
        this.resetPipelineState();
        this.finishedTaskNum.set(0);
        this.canceledTaskNum.set(0);
        this.failedTaskNum.set(0);
        this.coordinatorVertexList.forEach(PhysicalVertex::reset);
        this.physicalVertexList.forEach(PhysicalVertex::reset);
    }

    private void updateStateTimestamps(@NonNull PipelineStatus targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked non-null but is null");
        }
        Long[] stateTimestamps = (Long[])this.runningJobStateTimestampsIMap.get((Object)this.pipelineLocation);
        stateTimestamps[targetState.ordinal()] = System.currentTimeMillis();
        this.runningJobStateTimestampsIMap.set((Object)this.pipelineLocation, (Object)stateTimestamps);
    }

    private void resetPipelineState() throws Exception {
        RetryUtils.retryWithException(() -> {
            PipelineStatus pipelineState = this.getPipelineState();
            if (!pipelineState.isEndState()) {
                String message = String.format("%s reset state failed, only end state can be reset, current is %s", this.getPipelineFullName(), pipelineState);
                log.error(message);
                throw new IllegalStateException(message);
            }
            log.info(String.format("Reset pipeline %s state to %s", this.getPipelineFullName(), PipelineStatus.CREATED));
            this.updateStateTimestamps(PipelineStatus.CREATED);
            this.runningJobStateIMap.set((Object)this.pipelineLocation, (Object)PipelineStatus.CREATED);
            this.currPipelineStatus = PipelineStatus.CREATED;
            log.info(String.format("Reset pipeline %s state to %s complete", this.getPipelineFullName(), PipelineStatus.CREATED));
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException((Throwable)exception), 2000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareRestorePipeline() {
        Object object = this.restoreLock;
        synchronized (object) {
            try {
                Integer n = this.pipelineRestoreNum;
                Integer n2 = this.pipelineRestoreNum = Integer.valueOf(this.pipelineRestoreNum + 1);
                log.info(String.format("Restore time %s, pipeline %s", this.pipelineRestoreNum + "", this.pipelineFullName));
                this.reset();
                this.jobMaster.getCheckpointManager().reportedPipelineRunning(this.pipelineId, false);
                this.jobMaster.getPhysicalPlan().addPipelineEndCallback(this);
                log.info("Wait {}s and then restore the pipeline {}", (Object)this.pipelineRestoreIntervalSeconds, (Object)this.getPipelineFullName());
                Thread.sleep(this.pipelineRestoreIntervalSeconds * 1000);
                return true;
            }
            catch (Throwable e) {
                if (this.currPipelineStatus.isEndState()) {
                    return false;
                }
                this.jobMaster.getPhysicalPlan().addPipelineEndCallback(this);
                return true;
            }
        }
    }

    public void restorePipeline() {
        try {
            if (this.jobMaster.getCheckpointManager().isCompletedPipeline(this.pipelineId)) {
                this.forcePipelineFinish();
            }
            this.startSubPlanStateProcess();
        }
        catch (Throwable e) {
            log.error(String.format("Restore pipeline %s error with exception: ", this.pipelineFullName), e);
            this.makePipelineFailing(e);
            this.startSubPlanStateProcess();
        }
    }

    private void forcePipelineFinish() {
        this.coordinatorVertexList.forEach(coordinator -> coordinator.updateStateByExecutionService(new TaskExecutionState(coordinator.getTaskGroupLocation(), ExecutionState.FINISHED)));
        this.physicalVertexList.forEach(task -> task.updateStateByExecutionService(new TaskExecutionState(task.getTaskGroupLocation(), ExecutionState.FINISHED)));
    }

    public synchronized void restorePipelineState() {
        this.getPhysicalVertexList().forEach(task -> task.restoreExecutionState());
        this.getCoordinatorVertexList().forEach(task -> task.restoreExecutionState());
        if (this.getPipelineState().ordinal() < PipelineStatus.RUNNING.ordinal()) {
            this.updatePipelineState(PipelineStatus.CANCELING);
        } else if (PipelineStatus.RUNNING.equals((Object)this.getPipelineState())) {
            AtomicBoolean allTaskRunning = new AtomicBoolean(true);
            this.getCoordinatorVertexList().forEach(task -> {
                if (!task.getExecutionState().equals(ExecutionState.RUNNING)) {
                    allTaskRunning.set(false);
                    return;
                }
            });
            this.getPhysicalVertexList().forEach(task -> {
                if (!task.getExecutionState().equals(ExecutionState.RUNNING)) {
                    allTaskRunning.set(false);
                    return;
                }
            });
            this.jobMaster.getCheckpointManager().reportedPipelineRunning(this.getPipelineLocation().getPipelineId(), allTaskRunning.get());
        }
        this.startSubPlanStateProcess();
    }

    public List<PhysicalVertex> getPhysicalVertexList() {
        return this.physicalVertexList;
    }

    public List<PhysicalVertex> getCoordinatorVertexList() {
        return this.coordinatorVertexList;
    }

    public String getPipelineFullName() {
        return this.pipelineFullName;
    }

    public PipelineStatus getPipelineState() {
        return this.currPipelineStatus;
    }

    public PipelineLocation getPipelineLocation() {
        return this.pipelineLocation;
    }

    public void setJobMaster(JobMaster jobMaster) {
        this.jobMaster = jobMaster;
        this.coordinatorVertexList.forEach(coordinator -> coordinator.setJobMaster(jobMaster));
        this.physicalVertexList.forEach(task -> task.setJobMaster(jobMaster));
    }

    public int getPipelineRestoreNum() {
        return this.pipelineRestoreNum;
    }

    public void handleCheckpointError() {
        log.warn(String.format("%s checkpoint have error, cancel the pipeline", this.getPipelineFullName()));
        if (!this.getPipelineState().isEndState()) {
            this.updatePipelineState(PipelineStatus.CANCELING);
        }
    }

    public void startSubPlanStateProcess() {
        this.isRunning = true;
        log.info("{} state process is start", (Object)this.getPipelineFullName());
        this.stateProcess();
    }

    public void stopSubPlanStateProcess() {
        this.isRunning = false;
        log.info("{} state process is stop", (Object)this.getPipelineFullName());
    }

    private synchronized void stateProcess() {
        if (!this.isRunning) {
            log.warn(String.format("%s state process not start", this.pipelineFullName));
            return;
        }
        PipelineStatus state = this.getCurrPipelineStatus();
        switch (state) {
            case CREATED: {
                this.updatePipelineState(PipelineStatus.SCHEDULED);
                break;
            }
            case SCHEDULED: {
                try {
                    Map<TaskGroupLocation, SlotProfile> slotProfiles = ResourceUtils.applyResourceForPipeline(this.jobMaster, this);
                    log.debug("slotProfiles: {}, PipelineLocation: {}", slotProfiles, (Object)this.getPipelineLocation());
                    if (slotProfiles != null && !slotProfiles.isEmpty()) {
                        log.info("Resource allocation for pipeline {} completed. Task execution locations:", (Object)this.getPipelineFullName());
                        slotProfiles.forEach((taskLocation, slotProfile) -> {
                            if (slotProfile != null) {
                                log.info("  Task [{}] will be executed on worker [{}], slotID [{}], resourceProfile [{}], sequence [{}], assigned [{}]", new Object[]{taskLocation, slotProfile.getWorker(), slotProfile.getSlotID(), slotProfile.getResourceProfile(), slotProfile.getSequence(), slotProfile.getOwnerJobID()});
                            }
                        });
                    }
                    this.updatePipelineState(PipelineStatus.DEPLOYING);
                }
                catch (Exception e) {
                    this.makePipelineFailing(e);
                }
                break;
            }
            case DEPLOYING: {
                this.coordinatorVertexList.forEach(task -> {
                    if (task.getExecutionState().equals(ExecutionState.CREATED)) {
                        task.startPhysicalVertex();
                        task.makeTaskGroupDeploy();
                    }
                });
                this.physicalVertexList.forEach(task -> {
                    if (task.getExecutionState().equals(ExecutionState.CREATED)) {
                        task.startPhysicalVertex();
                        task.makeTaskGroupDeploy();
                    }
                });
                this.updatePipelineState(PipelineStatus.RUNNING);
                break;
            }
            case RUNNING: {
                break;
            }
            case FAILING: 
            case CANCELING: {
                this.coordinatorVertexList.forEach(task -> {
                    task.startPhysicalVertex();
                    task.cancel();
                });
                this.physicalVertexList.forEach(task -> {
                    task.startPhysicalVertex();
                    task.cancel();
                });
                break;
            }
            case FAILED: 
            case CANCELED: {
                if (this.checkNeedRestore(state) && this.prepareRestorePipeline()) {
                    this.jobMaster.releasePipelineResource(this);
                    this.jobMaster.preApplyResources(this);
                    this.restorePipeline();
                    return;
                }
                this.subPlanDone(state);
                this.stopSubPlanStateProcess();
                this.pipelineFuture.complete((Object)new PipelineExecutionState(this.pipelineId, state, this.errorByPhysicalVertex.get()));
                return;
            }
            case FINISHED: {
                this.subPlanDone(state);
                this.stopSubPlanStateProcess();
                this.pipelineFuture.complete((Object)new PipelineExecutionState(this.pipelineId, this.getPipelineState(), this.errorByPhysicalVertex.get()));
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown Pipeline State: " + this.getPipelineState());
            }
        }
    }

    public void makePipelineFailing(Throwable e) {
        this.errorByPhysicalVertex.compareAndSet(null, ExceptionUtils.getMessage((Throwable)e));
        this.updatePipelineState(PipelineStatus.FAILING);
    }

    public int getPipelineMaxRestoreNum() {
        return this.pipelineMaxRestoreNum;
    }

    public int getPipelineRestoreIntervalSeconds() {
        return this.pipelineRestoreIntervalSeconds;
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public AtomicInteger getFinishedTaskNum() {
        return this.finishedTaskNum;
    }

    public AtomicInteger getCanceledTaskNum() {
        return this.canceledTaskNum;
    }

    public AtomicInteger getFailedTaskNum() {
        return this.failedTaskNum;
    }

    public IMap<Object, Object> getRunningJobStateIMap() {
        return this.runningJobStateIMap;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public IMap<Object, Long[]> getRunningJobStateTimestampsIMap() {
        return this.runningJobStateTimestampsIMap;
    }

    public CompletableFuture<PipelineExecutionState> getPipelineFuture() {
        return this.pipelineFuture;
    }

    public AtomicReference<String> getErrorByPhysicalVertex() {
        return this.errorByPhysicalVertex;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public JobMaster getJobMaster() {
        return this.jobMaster;
    }

    public PassiveCompletableFuture<Void> getReSchedulerPipelineFuture() {
        return this.reSchedulerPipelineFuture;
    }

    public Object getRestoreLock() {
        return this.restoreLock;
    }

    public PipelineStatus getCurrPipelineStatus() {
        return this.currPipelineStatus;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public Map<TaskGroupLocation, SlotProfile> getSlotProfiles() {
        return this.slotProfiles;
    }

    public void setPipelineFuture(CompletableFuture<PipelineExecutionState> pipelineFuture) {
        this.pipelineFuture = pipelineFuture;
    }

    public void setErrorByPhysicalVertex(AtomicReference<String> errorByPhysicalVertex) {
        this.errorByPhysicalVertex = errorByPhysicalVertex;
    }

    public void setReSchedulerPipelineFuture(PassiveCompletableFuture<Void> reSchedulerPipelineFuture) {
        this.reSchedulerPipelineFuture = reSchedulerPipelineFuture;
    }

    public void setPipelineRestoreNum(Integer pipelineRestoreNum) {
        this.pipelineRestoreNum = pipelineRestoreNum;
    }

    public void setCurrPipelineStatus(PipelineStatus currPipelineStatus) {
        this.currPipelineStatus = currPipelineStatus;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setSlotProfiles(Map<TaskGroupLocation, SlotProfile> slotProfiles) {
        this.slotProfiles = slotProfiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubPlan)) {
            return false;
        }
        SubPlan other = (SubPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPipelineMaxRestoreNum() != other.getPipelineMaxRestoreNum()) {
            return false;
        }
        if (this.getPipelineRestoreIntervalSeconds() != other.getPipelineRestoreIntervalSeconds()) {
            return false;
        }
        if (this.getPipelineId() != other.getPipelineId()) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        if (this.getPipelineRestoreNum() != other.getPipelineRestoreNum()) {
            return false;
        }
        List<PhysicalVertex> this$physicalVertexList = this.getPhysicalVertexList();
        List<PhysicalVertex> other$physicalVertexList = other.getPhysicalVertexList();
        if (this$physicalVertexList == null ? other$physicalVertexList != null : !((Object)this$physicalVertexList).equals(other$physicalVertexList)) {
            return false;
        }
        List<PhysicalVertex> this$coordinatorVertexList = this.getCoordinatorVertexList();
        List<PhysicalVertex> other$coordinatorVertexList = other.getCoordinatorVertexList();
        if (this$coordinatorVertexList == null ? other$coordinatorVertexList != null : !((Object)this$coordinatorVertexList).equals(other$coordinatorVertexList)) {
            return false;
        }
        AtomicInteger this$finishedTaskNum = this.getFinishedTaskNum();
        AtomicInteger other$finishedTaskNum = other.getFinishedTaskNum();
        if (this$finishedTaskNum == null ? other$finishedTaskNum != null : !this$finishedTaskNum.equals(other$finishedTaskNum)) {
            return false;
        }
        AtomicInteger this$canceledTaskNum = this.getCanceledTaskNum();
        AtomicInteger other$canceledTaskNum = other.getCanceledTaskNum();
        if (this$canceledTaskNum == null ? other$canceledTaskNum != null : !this$canceledTaskNum.equals(other$canceledTaskNum)) {
            return false;
        }
        AtomicInteger this$failedTaskNum = this.getFailedTaskNum();
        AtomicInteger other$failedTaskNum = other.getFailedTaskNum();
        if (this$failedTaskNum == null ? other$failedTaskNum != null : !this$failedTaskNum.equals(other$failedTaskNum)) {
            return false;
        }
        String this$pipelineFullName = this.getPipelineFullName();
        String other$pipelineFullName = other.getPipelineFullName();
        if (this$pipelineFullName == null ? other$pipelineFullName != null : !this$pipelineFullName.equals(other$pipelineFullName)) {
            return false;
        }
        IMap<Object, Object> this$runningJobStateIMap = this.getRunningJobStateIMap();
        IMap<Object, Object> other$runningJobStateIMap = other.getRunningJobStateIMap();
        if (this$runningJobStateIMap == null ? other$runningJobStateIMap != null : !this$runningJobStateIMap.equals(other$runningJobStateIMap)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        IMap<Object, Long[]> this$runningJobStateTimestampsIMap = this.getRunningJobStateTimestampsIMap();
        IMap<Object, Long[]> other$runningJobStateTimestampsIMap = other.getRunningJobStateTimestampsIMap();
        if (this$runningJobStateTimestampsIMap == null ? other$runningJobStateTimestampsIMap != null : !this$runningJobStateTimestampsIMap.equals(other$runningJobStateTimestampsIMap)) {
            return false;
        }
        CompletableFuture<PipelineExecutionState> this$pipelineFuture = this.getPipelineFuture();
        CompletableFuture<PipelineExecutionState> other$pipelineFuture = other.getPipelineFuture();
        if (this$pipelineFuture == null ? other$pipelineFuture != null : !this$pipelineFuture.equals(other$pipelineFuture)) {
            return false;
        }
        PipelineLocation this$pipelineLocation = this.getPipelineLocation();
        PipelineLocation other$pipelineLocation = other.getPipelineLocation();
        if (this$pipelineLocation == null ? other$pipelineLocation != null : !((Object)this$pipelineLocation).equals(other$pipelineLocation)) {
            return false;
        }
        AtomicReference<String> this$errorByPhysicalVertex = this.getErrorByPhysicalVertex();
        AtomicReference<String> other$errorByPhysicalVertex = other.getErrorByPhysicalVertex();
        if (this$errorByPhysicalVertex == null ? other$errorByPhysicalVertex != null : !this$errorByPhysicalVertex.equals(other$errorByPhysicalVertex)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        JobMaster this$jobMaster = this.getJobMaster();
        JobMaster other$jobMaster = other.getJobMaster();
        if (this$jobMaster == null ? other$jobMaster != null : !this$jobMaster.equals(other$jobMaster)) {
            return false;
        }
        PassiveCompletableFuture<Void> this$reSchedulerPipelineFuture = this.getReSchedulerPipelineFuture();
        PassiveCompletableFuture<Void> other$reSchedulerPipelineFuture = other.getReSchedulerPipelineFuture();
        if (this$reSchedulerPipelineFuture == null ? other$reSchedulerPipelineFuture != null : !this$reSchedulerPipelineFuture.equals(other$reSchedulerPipelineFuture)) {
            return false;
        }
        Object this$restoreLock = this.getRestoreLock();
        Object other$restoreLock = other.getRestoreLock();
        if (this$restoreLock == null ? other$restoreLock != null : !this$restoreLock.equals(other$restoreLock)) {
            return false;
        }
        PipelineStatus this$currPipelineStatus = this.getCurrPipelineStatus();
        PipelineStatus other$currPipelineStatus = other.getCurrPipelineStatus();
        if (this$currPipelineStatus == null ? other$currPipelineStatus != null : !this$currPipelineStatus.equals(other$currPipelineStatus)) {
            return false;
        }
        Map<TaskGroupLocation, SlotProfile> this$slotProfiles = this.getSlotProfiles();
        Map<TaskGroupLocation, SlotProfile> other$slotProfiles = other.getSlotProfiles();
        return !(this$slotProfiles == null ? other$slotProfiles != null : !((Object)this$slotProfiles).equals(other$slotProfiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubPlan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPipelineMaxRestoreNum();
        result = result * 59 + this.getPipelineRestoreIntervalSeconds();
        result = result * 59 + this.getPipelineId();
        result = result * 59 + (this.isRunning() ? 79 : 97);
        result = result * 59 + this.getPipelineRestoreNum();
        List<PhysicalVertex> $physicalVertexList = this.getPhysicalVertexList();
        result = result * 59 + ($physicalVertexList == null ? 43 : ((Object)$physicalVertexList).hashCode());
        List<PhysicalVertex> $coordinatorVertexList = this.getCoordinatorVertexList();
        result = result * 59 + ($coordinatorVertexList == null ? 43 : ((Object)$coordinatorVertexList).hashCode());
        AtomicInteger $finishedTaskNum = this.getFinishedTaskNum();
        result = result * 59 + ($finishedTaskNum == null ? 43 : $finishedTaskNum.hashCode());
        AtomicInteger $canceledTaskNum = this.getCanceledTaskNum();
        result = result * 59 + ($canceledTaskNum == null ? 43 : $canceledTaskNum.hashCode());
        AtomicInteger $failedTaskNum = this.getFailedTaskNum();
        result = result * 59 + ($failedTaskNum == null ? 43 : $failedTaskNum.hashCode());
        String $pipelineFullName = this.getPipelineFullName();
        result = result * 59 + ($pipelineFullName == null ? 43 : $pipelineFullName.hashCode());
        IMap<Object, Object> $runningJobStateIMap = this.getRunningJobStateIMap();
        result = result * 59 + ($runningJobStateIMap == null ? 43 : $runningJobStateIMap.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        IMap<Object, Long[]> $runningJobStateTimestampsIMap = this.getRunningJobStateTimestampsIMap();
        result = result * 59 + ($runningJobStateTimestampsIMap == null ? 43 : $runningJobStateTimestampsIMap.hashCode());
        CompletableFuture<PipelineExecutionState> $pipelineFuture = this.getPipelineFuture();
        result = result * 59 + ($pipelineFuture == null ? 43 : $pipelineFuture.hashCode());
        PipelineLocation $pipelineLocation = this.getPipelineLocation();
        result = result * 59 + ($pipelineLocation == null ? 43 : ((Object)$pipelineLocation).hashCode());
        AtomicReference<String> $errorByPhysicalVertex = this.getErrorByPhysicalVertex();
        result = result * 59 + ($errorByPhysicalVertex == null ? 43 : $errorByPhysicalVertex.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        JobMaster $jobMaster = this.getJobMaster();
        result = result * 59 + ($jobMaster == null ? 43 : $jobMaster.hashCode());
        PassiveCompletableFuture<Void> $reSchedulerPipelineFuture = this.getReSchedulerPipelineFuture();
        result = result * 59 + ($reSchedulerPipelineFuture == null ? 43 : $reSchedulerPipelineFuture.hashCode());
        Object $restoreLock = this.getRestoreLock();
        result = result * 59 + ($restoreLock == null ? 43 : $restoreLock.hashCode());
        PipelineStatus $currPipelineStatus = this.getCurrPipelineStatus();
        result = result * 59 + ($currPipelineStatus == null ? 43 : $currPipelineStatus.hashCode());
        Map<TaskGroupLocation, SlotProfile> $slotProfiles = this.getSlotProfiles();
        result = result * 59 + ($slotProfiles == null ? 43 : ((Object)$slotProfiles).hashCode());
        return result;
    }

    public String toString() {
        return "SubPlan(pipelineMaxRestoreNum=" + this.getPipelineMaxRestoreNum() + ", pipelineRestoreIntervalSeconds=" + this.getPipelineRestoreIntervalSeconds() + ", physicalVertexList=" + this.getPhysicalVertexList() + ", coordinatorVertexList=" + this.getCoordinatorVertexList() + ", pipelineId=" + this.getPipelineId() + ", finishedTaskNum=" + this.getFinishedTaskNum() + ", canceledTaskNum=" + this.getCanceledTaskNum() + ", failedTaskNum=" + this.getFailedTaskNum() + ", pipelineFullName=" + this.getPipelineFullName() + ", runningJobStateIMap=" + this.getRunningJobStateIMap() + ", tags=" + this.getTags() + ", runningJobStateTimestampsIMap=" + this.getRunningJobStateTimestampsIMap() + ", pipelineFuture=" + this.getPipelineFuture() + ", pipelineLocation=" + this.getPipelineLocation() + ", errorByPhysicalVertex=" + this.getErrorByPhysicalVertex() + ", executorService=" + this.getExecutorService() + ", jobMaster=" + this.getJobMaster() + ", reSchedulerPipelineFuture=" + this.getReSchedulerPipelineFuture() + ", pipelineRestoreNum=" + this.getPipelineRestoreNum() + ", restoreLock=" + this.getRestoreLock() + ", currPipelineStatus=" + this.getCurrPipelineStatus() + ", isRunning=" + this.isRunning() + ", slotProfiles=" + this.getSlotProfiles() + ")";
    }
}

