/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.servlet;

import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.engine.common.config.server.HttpConfig;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.FormatType;
import org.apache.seatunnel.engine.server.rest.service.LogService;
import org.apache.seatunnel.engine.server.rest.servlet.LogBaseServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllNodeLogServlet
extends LogBaseServlet {
    private static final Logger log = LoggerFactory.getLogger(AllNodeLogServlet.class);
    private final LogService logService;

    public AllNodeLogServlet(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
        this.logService = new LogService(nodeEngine);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
        HttpConfig httpConfig = seaTunnelServer.getSeaTunnelConfig().getEngineConfig().getHttpConfig();
        String contextPath = httpConfig.getContextPath();
        String uri = req.getRequestURI();
        String param = this.logService.getLogParam(uri, contextPath);
        boolean isLogFile = param.contains(".log");
        String logName = isLogFile ? param : "";
        String jobId = !isLogFile ? param : "";
        String logPath = this.logService.getLogPath();
        if (StringUtils.isBlank((CharSequence)logName)) {
            FormatType formatType = FormatType.fromString(req.getParameter("format"));
            switch (formatType) {
                case JSON: {
                    this.writeJson(resp, this.logService.allNodeLogFormatJson(jobId));
                    return;
                }
            }
            this.writeHtml(resp, this.logService.allNodeLogFormatHtml(jobId));
        } else {
            this.prepareLogResponse(resp, logPath, logName);
        }
    }
}

