/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.service;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.utils.LogUtil;
import org.apache.seatunnel.engine.server.rest.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLogService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(BaseLogService.class);

    public BaseLogService(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
    }

    public String getLogPath() {
        try {
            return LogUtil.getLogPath();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("Get log path error,{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String sendGet(String urlString) {
        block14: {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(urlString).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.connect();
                if (connection.getResponseCode() != 200) break block14;
                try (InputStream is = connection.getInputStream();){
                    String string;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = is.read(buffer)) != -1) {
                            baos.write(buffer, 0, len);
                        }
                        string = baos.toString();
                    }
                    return string;
                }
            }
            catch (IOException e) {
                log.error("Send get Fail.{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
        }
        return null;
    }

    public String getLogParam(String uri, String contextPath) {
        uri = uri.substring(uri.indexOf(contextPath) + contextPath.length());
        int indexEnd = (uri = StringUtil.stripTrailingSlash((String)uri).substring(1)).indexOf(47);
        if (indexEnd != -1) {
            return uri.substring(indexEnd + 1);
        }
        return "";
    }

    protected String buildLogLink(String href, String name) {
        return "<li><a href=\"" + href + "\">" + name + "</a></li>\n";
    }

    protected String buildWebSiteContent(StringBuffer logLink) {
        return "<html><head><title>Seatunnel log</title></head>\n<body>\n <h2>Seatunnel log</h2>\n <ul>\n" + logLink.toString() + " </ul>\n</body></html>";
    }
}

