/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import java.util.HashMap;
import org.apache.seatunnel.engine.server.log.Log4j2HttpPostCommandProcessor;
import org.apache.seatunnel.engine.server.rest.service.EncryptConfigService;
import org.apache.seatunnel.engine.server.rest.service.JobInfoService;
import org.apache.seatunnel.engine.server.rest.service.UpdateTagsService;
import org.apache.seatunnel.engine.server.utils.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final Logger log = LoggerFactory.getLogger(RestHttpPostCommandProcessor.class);
    private final Log4j2HttpPostCommandProcessor original;
    private JobInfoService jobInfoService;
    private EncryptConfigService encryptConfigService;
    private UpdateTagsService updateTagsService;

    public RestHttpPostCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpPostCommandProcessor(textCommandService));
        this.jobInfoService = new JobInfoService(this.textCommandService.getNode().getNodeEngine());
        this.encryptConfigService = new EncryptConfigService(this.textCommandService.getNode().getNodeEngine());
        this.updateTagsService = new UpdateTagsService(this.textCommandService.getNode().getNodeEngine());
    }

    protected RestHttpPostCommandProcessor(TextCommandService textCommandService, Log4j2HttpPostCommandProcessor log4j2HttpPostCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpPostCommandProcessor.class));
        this.original = log4j2HttpPostCommandProcessor;
        this.jobInfoService = new JobInfoService(this.textCommandService.getNode().getNodeEngine());
        this.encryptConfigService = new EncryptConfigService(this.textCommandService.getNode().getNodeEngine());
        this.updateTagsService = new UpdateTagsService(this.textCommandService.getNode().getNodeEngine());
    }

    public void handle(HttpPostCommand httpPostCommand) {
        String uri = httpPostCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/submit-jobs")) {
                this.handleSubmitJobs(httpPostCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/submit-job")) {
                this.handleSubmitJob(httpPostCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/stop-jobs")) {
                this.handleStopJobs(httpPostCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/stop-job")) {
                this.handleStopJob(httpPostCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/encrypt-config")) {
                this.handleEncrypt(httpPostCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/update-tags")) {
                this.handleUpdateTags(httpPostCommand);
            } else {
                this.original.handle(httpPostCommand);
            }
        }
        catch (IllegalArgumentException e) {
            this.prepareResponse(HttpStatusCode.SC_400, (HttpCommand)httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse((Throwable)e));
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpPostCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse((Throwable)e));
        }
        this.textCommandService.sendResponse((TextCommand)httpPostCommand);
    }

    private void handleSubmitJobs(HttpPostCommand httpPostCommand) throws IllegalArgumentException {
        this.prepareResponse((HttpCommand)httpPostCommand, this.jobInfoService.submitJobs(httpPostCommand.getData()));
    }

    private void handleSubmitJob(HttpPostCommand httpPostCommand, String uri) throws IllegalArgumentException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        RestUtil.buildRequestParams(requestParams, uri);
        this.prepareResponse((HttpCommand)httpPostCommand, this.jobInfoService.submitJob(requestParams, httpPostCommand.getData()));
    }

    private void handleStopJobs(HttpPostCommand command) {
        this.prepareResponse((HttpCommand)command, this.jobInfoService.stopJobs(command.getData()));
    }

    private void handleStopJob(HttpPostCommand httpPostCommand) {
        this.prepareResponse((HttpCommand)httpPostCommand, this.jobInfoService.stopJob(httpPostCommand.getData()));
    }

    private void handleEncrypt(HttpPostCommand httpPostCommand) {
        this.prepareResponse((HttpCommand)httpPostCommand, this.encryptConfigService.encryptConfig(httpPostCommand.getData()));
    }

    private void handleUpdateTags(HttpPostCommand httpPostCommand) {
        this.prepareResponse((HttpCommand)httpPostCommand, this.updateTagsService.updateTags(httpPostCommand.getData()));
    }

    public void handleRejection(HttpPostCommand httpPostCommand) {
        this.handle(httpPostCommand);
    }
}

