/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.impl.NodeEngineImpl;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.apache.seatunnel.engine.server.log.FormatType;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.rest.service.JobInfoService;
import org.apache.seatunnel.engine.server.rest.service.LogService;
import org.apache.seatunnel.engine.server.rest.service.OverviewService;
import org.apache.seatunnel.engine.server.rest.service.RunningThreadService;
import org.apache.seatunnel.engine.server.rest.service.SystemMonitoringService;
import org.apache.seatunnel.engine.server.rest.service.ThreadDumpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private static final Logger log = LoggerFactory.getLogger(RestHttpGetCommandProcessor.class);
    private final Log4j2HttpGetCommandProcessor original;
    private NodeEngineImpl nodeEngine;
    private OverviewService overviewService;
    private JobInfoService jobInfoService;
    private SystemMonitoringService systemMonitoringService;
    private ThreadDumpService threadDumpService;
    private RunningThreadService runningThreadService;
    private LogService logService;

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
        this.nodeEngine = this.textCommandService.getNode().getNodeEngine();
        this.overviewService = new OverviewService(this.nodeEngine);
        this.jobInfoService = new JobInfoService(this.nodeEngine);
        this.systemMonitoringService = new SystemMonitoringService(this.nodeEngine);
        this.threadDumpService = new ThreadDumpService(this.nodeEngine);
        this.runningThreadService = new RunningThreadService(this.nodeEngine);
        this.logService = new LogService(this.nodeEngine);
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
        this.nodeEngine = this.textCommandService.getNode().getNodeEngine();
        this.overviewService = new OverviewService(this.nodeEngine);
        this.jobInfoService = new JobInfoService(this.nodeEngine);
        this.systemMonitoringService = new SystemMonitoringService(this.nodeEngine);
        this.threadDumpService = new ThreadDumpService(this.nodeEngine);
        this.runningThreadService = new RunningThreadService(this.nodeEngine);
        this.logService = new LogService(this.nodeEngine);
    }

    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
                this.handleRunningJobsInfo(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/finished-jobs")) {
                this.handleFinishedJobsInfo(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-job") || uri.startsWith("/hazelcast/rest/maps/job-info")) {
                this.handleJobInfoById(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/system-monitoring-information")) {
                this.getSystemMonitoringInformation(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-threads")) {
                this.getRunningThread(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/overview")) {
                this.overView(httpGetCommand, uri);
            } else if (uri.equals("/hazelcast/rest/instance/metrics")) {
                this.handleMetrics(httpGetCommand, "text/plain; version=0.0.4; charset=utf-8");
            } else if (uri.equals("/hazelcast/rest/instance/openmetrics")) {
                this.handleMetrics(httpGetCommand, "application/openmetrics-text; version=1.0.0; charset=utf-8");
            } else if (uri.startsWith("/hazelcast/rest/maps/thread-dump")) {
                this.getThreadDump(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/get-all-log-name")) {
                this.getAllLogName(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/logs")) {
                this.getAllNodeLog(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/log")) {
                this.getCurrentNodeLog(httpGetCommand, uri);
            } else {
                this.original.handle(httpGetCommand);
            }
        }
        catch (IndexOutOfBoundsException e) {
            httpGetCommand.send400();
        }
        catch (IllegalArgumentException e) {
            this.prepareResponse(HttpStatusCode.SC_400, (HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse((Throwable)e));
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpGetCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse((Throwable)e));
        }
        this.textCommandService.sendResponse((TextCommand)httpGetCommand);
    }

    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    public void overView(HttpGetCommand command, String uri) {
        String tagStr;
        if ((uri = StringUtil.stripTrailingSlash((String)uri)).contains("?")) {
            int index = uri.indexOf("?");
            tagStr = uri.substring(index + 1);
        } else {
            tagStr = "";
        }
        Map<String, String> tags = Arrays.stream(tagStr.split("&")).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        this.prepareResponse((HttpCommand)command, JsonUtil.toJsonObject((Map)JsonUtils.toMap((String)JsonUtils.toJsonString((Object)this.overviewService.getOverviewInfo(tags)))));
    }

    public void getThreadDump(HttpGetCommand command) {
        this.prepareResponse((HttpCommand)command, this.threadDumpService.getThreadDump());
    }

    private void getSystemMonitoringInformation(HttpGetCommand command) {
        this.prepareResponse((HttpCommand)command, this.systemMonitoringService.getSystemMonitoringInformationJsonValues());
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        this.prepareResponse((HttpCommand)command, this.jobInfoService.getRunningJobsJson());
    }

    private void handleFinishedJobsInfo(HttpGetCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash((String)uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        String state = indexEnd == -1 ? "" : uri.substring(indexEnd + 1);
        this.prepareResponse((HttpCommand)command, this.jobInfoService.getJobsByStateJson(state));
    }

    private void handleJobInfoById(HttpGetCommand command, String uri) {
        uri = StringUtil.stripTrailingSlash((String)uri);
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String jobId = uri.substring(indexEnd + 1);
        this.prepareResponse((HttpCommand)command, this.jobInfoService.getJobInfoJson(Long.valueOf(jobId)));
    }

    private void getRunningThread(HttpGetCommand command) {
        this.prepareResponse((HttpCommand)command, this.runningThreadService.getRunningThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetrics(HttpGetCommand httpGetCommand, String contentType) {
        log.info("Metrics request received");
        StringWriter stringWriter = new StringWriter();
        NodeExtension nodeExtension = (NodeExtension)this.textCommandService.getNode().getNodeExtension();
        try {
            TextFormat.writeFormat((String)contentType, (Writer)stringWriter, (Enumeration)nodeExtension.getCollectorRegistry().metricFamilySamples());
            this.prepareResponse((HttpCommand)httpGetCommand, stringWriter.toString());
        }
        catch (IOException e) {
            httpGetCommand.send400();
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                this.logger.warning("An error occurred while handling request " + httpGetCommand, (Throwable)e);
                this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse((Throwable)e));
            }
        }
    }

    private void getAllNodeLog(HttpGetCommand httpGetCommand, String uri) {
        String param = this.getParam(uri);
        boolean isLogFile = param.contains(".log");
        String logName = isLogFile ? param : "";
        String jobId = !isLogFile ? param : "";
        String logPath = this.logService.getLogPath();
        if (StringUtils.isBlank((CharSequence)logPath)) {
            this.logger.warning("Log file path is empty, no log file path configured in the current configuration file");
            httpGetCommand.send404();
            return;
        }
        if (StringUtils.isBlank((CharSequence)logName)) {
            FormatType formatType = this.getFormatType(uri);
            switch (formatType) {
                case JSON: {
                    this.prepareResponse((HttpCommand)httpGetCommand, this.logService.allNodeLogFormatJson(jobId));
                    return;
                }
            }
            this.prepareResponse((HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.getRestValue(this.logService.allNodeLogFormatHtml(jobId)));
        } else {
            this.prepareLogResponse(httpGetCommand, logPath, logName);
        }
    }

    private FormatType getFormatType(String uri) {
        Map<String, String> uriParam = this.getUriParam(uri);
        return FormatType.fromString(uriParam.get("format"));
    }

    private Map<String, String> getUriParam(String uri) {
        String queryString = uri.contains("?") ? uri.substring(uri.indexOf("?") + 1) : "";
        return Arrays.stream(queryString.split("&")).map(param -> param.split("=", 2)).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
    }

    private String getParam(String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash((String)uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        if (indexEnd != -1) {
            String param = uri.substring(indexEnd + 1);
            this.logger.fine(String.format("Request: %s , Param: %s", uri, param));
            return param;
        }
        return "";
    }

    private static RestValue getRestValue(String logContent) {
        RestValue restValue = new RestValue();
        restValue.setContentType("text/html; charset=UTF-8".getBytes(StandardCharsets.UTF_8));
        restValue.setValue(logContent.getBytes(StandardCharsets.UTF_8));
        return restValue;
    }

    private void getCurrentNodeLog(HttpGetCommand httpGetCommand, String uri) {
        String logName = this.getParam(uri);
        String logPath = this.logService.getLogPath();
        if (StringUtils.isBlank((CharSequence)logName)) {
            this.prepareResponse((HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.getRestValue(this.logService.currentNodeLog(uri)));
        } else {
            this.prepareLogResponse(httpGetCommand, logPath, logName);
        }
    }

    private void prepareLogResponse(HttpGetCommand httpGetCommand, String logPath, String logName) {
        String logFilePath = logPath + "/" + logName;
        try {
            String logContent = FileUtils.readFileToStr((Path)new File(logFilePath).toPath());
            this.prepareResponse((HttpCommand)httpGetCommand, logContent);
        }
        catch (SeaTunnelRuntimeException e) {
            httpGetCommand.send400();
            this.logger.warning(String.format("Log file content is empty, get log path : %s", logFilePath));
        }
    }

    private void getAllLogName(HttpGetCommand httpGetCommand) {
        try {
            this.prepareResponse((HttpCommand)httpGetCommand, JsonUtils.toJsonString(this.logService.allLogName()));
        }
        catch (SeaTunnelRuntimeException e) {
            httpGetCommand.send400();
            this.logger.warning(String.format("Log file name get failed, get log path: %s", this.logService.getLogPath()));
        }
    }
}

