/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.joiner;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.engine.server.joiner.LiteNodeDropOutTcpIpJoiner;

public class LiteNodeDropOutDiscoveryJoiner
extends LiteNodeDropOutTcpIpJoiner {
    private final DiscoveryService discoveryService;
    private final boolean usePublicAddress;
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(500L));
    private final int maximumWaitingTimeBeforeJoinSeconds;

    public LiteNodeDropOutDiscoveryJoiner(Node node) {
        super(node);
        this.maximumWaitingTimeBeforeJoinSeconds = node.getProperties().getInteger(ClusterProperty.WAIT_SECONDS_BEFORE_JOIN);
        this.discoveryService = node.discoveryService;
        this.usePublicAddress = this.usePublicAddress(node.getConfig().getNetworkConfig().getJoin());
    }

    private boolean usePublicAddress(JoinConfig join) {
        return this.node.getProperties().getBoolean(ClusterProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED) || AliasedDiscoveryConfigUtils.allUsePublicAddress((List)AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom((JoinConfig)join));
    }

    @Override
    protected Collection<Address> getPossibleAddressesForInitialJoin() {
        long deadLine = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.maximumWaitingTimeBeforeJoinSeconds);
        int i = 0;
        while (System.nanoTime() < deadLine) {
            Collection<Address> possibleAddresses = this.getPossibleAddresses();
            if (!possibleAddresses.isEmpty()) {
                return possibleAddresses;
            }
            this.idleStrategy.idle((long)i);
            ++i;
        }
        return Collections.emptyList();
    }

    @Override
    protected Collection<Address> getPossibleAddresses() {
        Iterable discoveredNodes = (Iterable)Preconditions.checkNotNull((Object)this.discoveryService.discoverNodes(), (String)"Discovered nodes cannot be null!");
        MemberImpl localMember = this.node.nodeEngine.getLocalMember();
        Set localAddresses = this.node.getLocalAddressRegistry().getLocalAddresses();
        ArrayList<Address> possibleMembers = new ArrayList<Address>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            Address discoveredAddress;
            Address address = discoveredAddress = this.usePublicAddress ? discoveryNode.getPublicAddress() : discoveryNode.getPrivateAddress();
            if (localAddresses.contains(discoveredAddress)) {
                if (this.usePublicAddress || discoveryNode.getPublicAddress() == null) continue;
                localMember.getAddressMap().put(EndpointQualifier.resolve((ProtocolType)ProtocolType.CLIENT, (String)"public"), this.publicAddress(localMember, discoveryNode));
                continue;
            }
            possibleMembers.add(discoveredAddress);
        }
        return possibleMembers;
    }

    private Address publicAddress(MemberImpl localMember, DiscoveryNode discoveryNode) {
        if (localMember.getAddressMap().containsKey(EndpointQualifier.CLIENT)) {
            try {
                String publicHost = discoveryNode.getPublicAddress().getHost();
                int clientPort = ((Address)localMember.getAddressMap().get(EndpointQualifier.CLIENT)).getPort();
                return new Address(publicHost, clientPort);
            }
            catch (Exception var5) {
                Exception e = var5;
                this.logger.fine((Throwable)e);
            }
        }
        return discoveryNode.getPublicAddress();
    }
}

