/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.utils.concurrent.CompletableFuture;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.resourcemanager.NoEnoughResourceException;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;

public class ResourceUtils {
    private static final ILogger LOGGER = Logger.getLogger(ResourceUtils.class);

    public static void applyResourceForPipeline(@NonNull JobMaster jobMaster, @NonNull SubPlan subPlan) {
        if (jobMaster == null) {
            throw new NullPointerException("jobMaster is marked non-null but is null");
        }
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked non-null but is null");
        }
        HashMap<TaskGroupLocation, CompletableFuture<SlotProfile>> futures = new HashMap<TaskGroupLocation, CompletableFuture<SlotProfile>>();
        HashMap<TaskGroupLocation, SlotProfile> slotProfiles = new HashMap<TaskGroupLocation, SlotProfile>();
        Map<TaskGroupLocation, CompletableFuture<SlotProfile>> preApplyResourceFutures = jobMaster.getPhysicalPlan().getPreApplyResourceFutures();
        ResourceUtils.allocateResources(subPlan, futures, preApplyResourceFutures);
        futures.forEach((key, value) -> {
            try {
                slotProfiles.put((TaskGroupLocation)key, value == null ? null : (SlotProfile)value.join());
            }
            catch (CompletionException e) {
                LOGGER.warning("Failed to join future for task group location: " + key, (Throwable)e);
            }
        });
        subPlan.getJobMaster().setOwnedSlotProfiles(subPlan.getPipelineLocation(), slotProfiles);
        if (futures.size() != slotProfiles.size()) {
            throw new NoEnoughResourceException();
        }
    }

    private static void allocateResources(SubPlan subPlan, Map<TaskGroupLocation, CompletableFuture<SlotProfile>> futures, Map<TaskGroupLocation, CompletableFuture<SlotProfile>> preApplyResourceFutures) {
        subPlan.getCoordinatorVertexList().forEach(coordinator -> {
            TaskGroupLocation taskGroupLocation = coordinator.getTaskGroupLocation();
            futures.put(taskGroupLocation, (CompletableFuture)preApplyResourceFutures.get(taskGroupLocation));
        });
        subPlan.getPhysicalVertexList().forEach(task -> {
            TaskGroupLocation taskGroupLocation = task.getTaskGroupLocation();
            futures.put(taskGroupLocation, (CompletableFuture)preApplyResourceFutures.get(taskGroupLocation));
        });
    }

    public static CompletableFuture<SlotProfile> applyResourceForTask(ResourceManager resourceManager, PhysicalVertex task, Map<String, String> tags) {
        try {
            return resourceManager.applyResource(task.getTaskGroupLocation().getJobId(), new ResourceProfile(), tags);
        }
        catch (NoEnoughResourceException e) {
            LOGGER.severe(String.format("Job Resource not enough, jobId: %s, message: %s", task.getTaskGroupLocation().getJobId(), ExceptionUtils.getMessage((Throwable)e)));
            return null;
        }
    }
}

