/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.instance.impl.DefaultNodeContext;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Joiner;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.spi.properties.ClusterProperty;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.apache.seatunnel.engine.server.joiner.LiteNodeDropOutDiscoveryJoiner;
import org.apache.seatunnel.engine.server.joiner.LiteNodeDropOutMulticastJoiner;
import org.apache.seatunnel.engine.server.joiner.LiteNodeDropOutTcpIpJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelNodeContext
extends DefaultNodeContext {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelNodeContext.class);
    private final SeaTunnelConfig seaTunnelConfig;

    public SeaTunnelNodeContext(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.seaTunnelConfig = seaTunnelConfig;
    }

    public com.hazelcast.instance.impl.NodeExtension createNodeExtension(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return new NodeExtension(node, this.seaTunnelConfig);
    }

    public Joiner createJoiner(Node node) {
        JoinConfig join = ConfigAccessor.getActiveMemberNetworkConfig((Config)this.seaTunnelConfig.getHazelcastConfig()).getJoin();
        join.verify();
        if (join.getMulticastConfig().isEnabled() && node.multicastService != null) {
            log.info("Using LiteNodeDropOutMulticast Multicast discovery");
            return new LiteNodeDropOutMulticastJoiner(node);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            log.info("Using LiteNodeDropOutTcpIpJoiner TCP/IP discovery");
            return new LiteNodeDropOutTcpIpJoiner(node);
        }
        if (node.getProperties().getBoolean(ClusterProperty.DISCOVERY_SPI_ENABLED) || this.isAnyAliasedConfigEnabled(join) || join.isAutoDetectionEnabled()) {
            log.info("Using LiteNodeDropOutDiscoveryJoiner Discovery SPI");
            return new LiteNodeDropOutDiscoveryJoiner(node);
        }
        return null;
    }

    private boolean isAnyAliasedConfigEnabled(JoinConfig join) {
        return !AliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs((JoinConfig)join).isEmpty();
    }
}

