/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.rest.filter.ExceptionHandlingFilter;
import org.apache.seatunnel.engine.server.rest.servlet.AllLogNameServlet;
import org.apache.seatunnel.engine.server.rest.servlet.AllNodeLogServlet;
import org.apache.seatunnel.engine.server.rest.servlet.CurrentNodeLogServlet;
import org.apache.seatunnel.engine.server.rest.servlet.EncryptConfigServlet;
import org.apache.seatunnel.engine.server.rest.servlet.FinishedJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.JobInfoServlet;
import org.apache.seatunnel.engine.server.rest.servlet.MetricsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.OverviewServlet;
import org.apache.seatunnel.engine.server.rest.servlet.RunningJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.RunningThreadsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.StopJobServlet;
import org.apache.seatunnel.engine.server.rest.servlet.StopJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobByUploadFileServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SubmitJobsServlet;
import org.apache.seatunnel.engine.server.rest.servlet.SystemMonitoringServlet;
import org.apache.seatunnel.engine.server.rest.servlet.ThreadDumpServlet;
import org.apache.seatunnel.engine.server.rest.servlet.UpdateTagsServlet;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.Handler;
import org.apache.seatunnel.shade.org.eclipse.jetty.server.Server;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.DefaultServlet;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.seatunnel.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyService {
    private static final Logger log = LoggerFactory.getLogger(JettyService.class);
    private NodeEngineImpl nodeEngine;
    private SeaTunnelConfig seaTunnelConfig;
    Server server;

    public JettyService(NodeEngineImpl nodeEngine, SeaTunnelConfig seaTunnelConfig) {
        this.nodeEngine = nodeEngine;
        this.seaTunnelConfig = seaTunnelConfig;
        int port = seaTunnelConfig.getEngineConfig().getHttpConfig().getPort();
        if (seaTunnelConfig.getEngineConfig().getHttpConfig().isEnableDynamicPort()) {
            port = this.chooseAppropriatePort(port, seaTunnelConfig.getEngineConfig().getHttpConfig().getPortRange());
        }
        log.info("SeaTunnel REST service will start on port {}", (Object)port);
        this.server = new Server(port);
    }

    public void createJettyServer() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(this.seaTunnelConfig.getEngineConfig().getHttpConfig().getContextPath());
        FilterHolder filterHolder = new FilterHolder((Filter)new ExceptionHandlingFilter());
        context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder defaultServlet = new ServletHolder("default", DefaultServlet.class);
        URL uiResource = JettyService.class.getClassLoader().getResource("ui");
        if (uiResource != null) {
            defaultServlet.setInitParameter("resourceBase", uiResource.toExternalForm());
        } else {
            log.warn("UI resources not found in classpath");
        }
        context.addServlet(defaultServlet, "/");
        ServletHolder overviewHolder = new ServletHolder((Servlet)new OverviewServlet(this.nodeEngine));
        ServletHolder runningJobsHolder = new ServletHolder((Servlet)new RunningJobsServlet(this.nodeEngine));
        ServletHolder finishedJobsHolder = new ServletHolder((Servlet)new FinishedJobsServlet(this.nodeEngine));
        ServletHolder systemMonitoringHolder = new ServletHolder((Servlet)new SystemMonitoringServlet(this.nodeEngine));
        ServletHolder jobInfoHolder = new ServletHolder((Servlet)new JobInfoServlet(this.nodeEngine));
        ServletHolder threadDumpHolder = new ServletHolder((Servlet)new ThreadDumpServlet(this.nodeEngine));
        ServletHolder submitJobHolder = new ServletHolder((Servlet)new SubmitJobServlet(this.nodeEngine));
        ServletHolder submitJobByUploadFileHolder = new ServletHolder((Servlet)new SubmitJobByUploadFileServlet(this.nodeEngine));
        ServletHolder submitJobsHolder = new ServletHolder((Servlet)new SubmitJobsServlet(this.nodeEngine));
        ServletHolder stopJobHolder = new ServletHolder((Servlet)new StopJobServlet(this.nodeEngine));
        ServletHolder stopJobsHolder = new ServletHolder((Servlet)new StopJobsServlet(this.nodeEngine));
        ServletHolder encryptConfigHolder = new ServletHolder((Servlet)new EncryptConfigServlet(this.nodeEngine));
        ServletHolder updateTagsHandler = new ServletHolder((Servlet)new UpdateTagsServlet(this.nodeEngine));
        ServletHolder runningThreadsHolder = new ServletHolder((Servlet)new RunningThreadsServlet(this.nodeEngine));
        ServletHolder allNodeLogServletHolder = new ServletHolder((Servlet)new AllNodeLogServlet(this.nodeEngine));
        ServletHolder currentNodeLogServlet = new ServletHolder((Servlet)new CurrentNodeLogServlet(this.nodeEngine));
        ServletHolder allLogNameServlet = new ServletHolder((Servlet)new AllLogNameServlet(this.nodeEngine));
        ServletHolder metricsServlet = new ServletHolder((Servlet)new MetricsServlet(this.nodeEngine));
        context.addServlet(overviewHolder, JettyService.convertUrlToPath("/overview"));
        context.addServlet(runningJobsHolder, JettyService.convertUrlToPath("/running-jobs"));
        context.addServlet(finishedJobsHolder, JettyService.convertUrlToPath("/finished-jobs"));
        context.addServlet(systemMonitoringHolder, JettyService.convertUrlToPath("/system-monitoring-information"));
        context.addServlet(jobInfoHolder, JettyService.convertUrlToPath("/job-info"));
        context.addServlet(jobInfoHolder, JettyService.convertUrlToPath("/running-job"));
        context.addServlet(threadDumpHolder, JettyService.convertUrlToPath("/thread-dump"));
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement("");
        submitJobByUploadFileHolder.getRegistration().setMultipartConfig(multipartConfigElement);
        context.addServlet(submitJobByUploadFileHolder, JettyService.convertUrlToPath("/submit-job/upload"));
        context.addServlet(submitJobHolder, JettyService.convertUrlToPath("/submit-job"));
        context.addServlet(submitJobsHolder, JettyService.convertUrlToPath("/submit-jobs"));
        context.addServlet(stopJobHolder, JettyService.convertUrlToPath("/stop-job"));
        context.addServlet(stopJobsHolder, JettyService.convertUrlToPath("/stop-jobs"));
        context.addServlet(encryptConfigHolder, JettyService.convertUrlToPath("/encrypt-config"));
        context.addServlet(updateTagsHandler, JettyService.convertUrlToPath("/update-tags"));
        context.addServlet(runningThreadsHolder, JettyService.convertUrlToPath("/running-threads"));
        context.addServlet(allNodeLogServletHolder, JettyService.convertUrlToPath("/logs"));
        context.addServlet(currentNodeLogServlet, JettyService.convertUrlToPath("/log"));
        context.addServlet(allLogNameServlet, JettyService.convertUrlToPath("/get-all-log-name"));
        context.addServlet(metricsServlet, JettyService.convertUrlToPath("/metrics"));
        context.addServlet(metricsServlet, JettyService.convertUrlToPath("/openmetrics"));
        this.server.setHandler((Handler)context);
        try {
            this.server.start();
        }
        catch (Exception e) {
            log.error("Jetty server start failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void shutdownJettyServer() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.error("Jetty server stop failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String convertUrlToPath(String url) {
        return url + "/*";
    }

    public int chooseAppropriatePort(int initialPort, int portRange) {
        for (int port = initialPort; port <= initialPort + portRange; ++port) {
            if (this.isPortInUse(port)) continue;
            return port;
        }
        throw new RuntimeException("Jetty failed to start, No available port found in the range!");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isPortInUse(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            DatagramSocket ds = new DatagramSocket(port);
            try {
                boolean bl = false;
                ds.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return true;
        }
    }
}

