/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.example.engine;

import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.seatunnel.core.starter.SeaTunnel;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.example.engine.SeaTunnelEngineLocalExample;

public class SeaTunnelEngineClusterClientExample {
    public static void main(String[] args) throws Exception {
        String id = "834720088434147329";
        String configurePath = "/examples/fake_to_console.conf";
        SeaTunnelEngineClusterClientExample.submit(configurePath, id);
    }

    public static void list() {
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        clientCommandArgs.setListJob(true);
        SeaTunnel.run((Command)clientCommandArgs.buildCommand());
    }

    public static void submit(String configurePath, String id) throws FileNotFoundException, URISyntaxException {
        String configFile = SeaTunnelEngineLocalExample.getTestConfigFile(configurePath);
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        clientCommandArgs.setConfigFile(configFile);
        clientCommandArgs.setCheckConfig(false);
        clientCommandArgs.setJobName(Paths.get(configFile, new String[0]).getFileName().toString());
        clientCommandArgs.setAsync(true);
        clientCommandArgs.setCustomJobId(id);
        SeaTunnel.run((Command)clientCommandArgs.buildCommand());
    }

    public static void restore(String configurePath, String id) throws FileNotFoundException, URISyntaxException {
        String configFile = SeaTunnelEngineLocalExample.getTestConfigFile(configurePath);
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        clientCommandArgs.setConfigFile(configFile);
        clientCommandArgs.setRestoreJobId(id);
        clientCommandArgs.setAsync(true);
        SeaTunnel.run((Command)clientCommandArgs.buildCommand());
    }

    public static void savepoint(String id) {
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        clientCommandArgs.setSavePointJobId(id);
        SeaTunnel.run((Command)clientCommandArgs.buildCommand());
    }

    public static void cancel(String id) {
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        clientCommandArgs.setCancelJobId(Collections.singletonList(id));
        SeaTunnel.run((Command)clientCommandArgs.buildCommand());
    }
}

