/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class DebeziumJsonSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "c";
    private static final String OP_DELETE = "d";
    public static final String FORMAT = "Debezium";
    private final JsonSerializationSchema jsonSerializer;
    private transient SeaTunnelRow genericRow;

    public DebeziumJsonSerializationSchema(SeaTunnelRowType rowType) {
        this.jsonSerializer = new JsonSerializationSchema(DebeziumJsonSerializationSchema.createJsonRowType(rowType));
        this.genericRow = new SeaTunnelRow(5);
    }

    public DebeziumJsonSerializationSchema(SeaTunnelRowType rowType, Charset charset) {
        this.jsonSerializer = new JsonSerializationSchema(DebeziumJsonSerializationSchema.createJsonRowType(rowType), charset);
        this.genericRow = new SeaTunnelRow(5);
    }

    public byte[] serialize(SeaTunnelRow row) {
        try {
            HashMap<String, String> source2 = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)row.getTableId())) {
                source2.put("schema", TablePath.of((String)row.getTableId()).getSchemaName());
                source2.put("database", TablePath.of((String)row.getTableId()).getDatabaseName());
                source2.put("table", TablePath.of((String)row.getTableId()).getTableName());
            }
            switch (row.getRowKind()) {
                case INSERT: 
                case UPDATE_AFTER: {
                    this.genericRow.setField(0, null);
                    this.genericRow.setField(1, (Object)row);
                    this.genericRow.setField(2, (Object)OP_INSERT);
                    this.genericRow.setField(3, source2);
                    if (row.getOptions() != null && row.getOptions().containsKey(CommonOptions.EVENT_TIME.getName())) {
                        this.genericRow.setField(4, row.getOptions().get(CommonOptions.EVENT_TIME.getName()));
                    } else {
                        this.genericRow.setField(4, null);
                    }
                    return this.jsonSerializer.serialize(this.genericRow);
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    this.genericRow.setField(0, (Object)row);
                    this.genericRow.setField(1, null);
                    this.genericRow.setField(2, (Object)OP_DELETE);
                    this.genericRow.setField(3, source2);
                    if (row.getOptions() != null && row.getOptions().containsKey(CommonOptions.EVENT_TIME.getName())) {
                        this.genericRow.setField(4, row.getOptions().get(CommonOptions.EVENT_TIME.getName()));
                    }
                    return this.jsonSerializer.serialize(this.genericRow);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported operation '%s' for row kind.", row.getRowKind()));
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)row.toString(), (Throwable)t);
        }
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return new SeaTunnelRowType(new String[]{"before", "after", "op", "source", "ts_ms"}, new SeaTunnelDataType[]{databaseSchema, databaseSchema, BasicType.STRING_TYPE, new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.STRING_TYPE), BasicType.LONG_TYPE});
    }
}

